/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.library.processors;

import io.continual.builder.Builder;
import io.continual.services.processor.config.readers.ConfigLoadContext;
import io.continual.services.processor.engine.model.MessageProcessingContext;
import io.continual.services.processor.engine.model.Processor;
import io.continual.services.processor.engine.model.Sink;
import org.json.JSONException;
import org.json.JSONObject;

public class SendToSink
implements Processor {
    private final String fToSink;
    private Sink fSink;
    private boolean fSinkLookupComplete;

    public SendToSink(String sinkName) {
        this.fToSink = sinkName;
        this.fSink = null;
        this.fSinkLookupComplete = false;
    }

    public SendToSink(ConfigLoadContext sc, JSONObject config) throws Builder.BuildFailure {
        try {
            this.fToSink = config.getString("to");
        }
        catch (JSONException e) {
            throw new Builder.BuildFailure((Throwable)e);
        }
        this.fSink = null;
        this.fSinkLookupComplete = false;
    }

    @Override
    public void process(MessageProcessingContext context) {
        if (this.fSink == null && !this.fSinkLookupComplete) {
            this.fSinkLookupComplete = true;
            this.fSink = context.getSink(this.fToSink);
            if (this.fSink == null) {
                context.warn("Unknown sink " + this.fToSink);
            }
        }
        if (this.fSink != null) {
            this.fSink.process(context);
        }
    }
}

