/*
 *	Copyright 2019, Continual.io
 *
 *	Licensed under the Apache License, Version 2.0 (the "License");
 *	you may not use this file except in compliance with the License.
 *	You may obtain a copy of the License at
 *	
 *	http://www.apache.org/licenses/LICENSE-2.0
 *	
 *	Unless required by applicable law or agreed to in writing, software
 *	distributed under the License is distributed on an "AS IS" BASIS,
 *	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *	See the License for the specific language governing permissions and
 *	limitations under the License.
 */

package io.continual.services.processor.engine.library.sinks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.json.JSONObject;

import io.continual.builder.Builder.BuildFailure;
import io.continual.services.ServiceContainer;
import io.continual.services.processor.engine.model.Message;
import io.continual.services.processor.engine.model.Sink;

/**
 * A JSON object stream sink.
 */
public class JsonObjectStreamSink implements Sink
{
	public JsonObjectStreamSink ( final ServiceContainer sc, JSONObject config ) throws BuildFailure
	{
		fPending = new ArrayList<JSONObject> ();
	}

	@Override
	public void init ()
	{
	}

	@Override
	public void flush ()
	{
	}

	@Override
	public void process ( Message msg )
	{
		fPending.add ( msg.toJson () );
	}

	@Override
	public void close () throws IOException
	{
	}

	public List<JSONObject> getList ()
	{
		return fPending;
	}
	
	private final ArrayList<JSONObject> fPending;
}
