/*
 * Decompiled with CFR 0.152.
 */
package io.contek.invoker.security;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import io.contek.invoker.security.ApiKey;
import io.contek.invoker.security.ICredential;
import io.contek.invoker.security.SecretKeyAlgorithm;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class SimpleCredential
implements ICredential {
    private final ApiKey apiKey;
    private final SecretKeyAlgorithm algorithm;
    private final BaseEncoding encoding;

    protected SimpleCredential(ApiKey apiKey, SecretKeyAlgorithm algorithm, BaseEncoding encoding) {
        this.apiKey = apiKey;
        this.algorithm = algorithm;
        this.encoding = encoding;
    }

    @Override
    public final boolean isAnonymous() {
        return false;
    }

    @Override
    public final String getApiKeyId() {
        return this.apiKey.getId();
    }

    @Override
    public ImmutableMap<String, String> getProperties() {
        return this.apiKey.getProperties();
    }

    @Override
    public final String sign(String payload) {
        return this.encoding.encode(this.algorithm.setupMac(this.apiKey.getSecret()).doFinal(payload.getBytes(Charsets.UTF_8)));
    }
}

