/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.maven.resolver;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.stax2.XMLInputFactory2;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.version.Version;

@Mojo(name="resolve-kafka-range", defaultPhase=LifecyclePhase.VALIDATE, threadSafe=true, requiresProject=false)
public class ResolveKafkaVersionRangeMojo
extends AbstractMojo {
    private static final Pattern SNAPSHOT_TIMESTAMP = Pattern.compile("^(.*-)?([0-9]{8}\\.[0-9]{6}-[0-9]+)$");
    private static final String CE_KAFKA_VERSION = "ce.kafka.version";
    private static final String CCS_KAFKA_VERSION = "kafka.version";
    @Parameter(property="groupId", required=true)
    private String groupId;
    @Parameter(property="artifactId", required=true)
    private String artifactId;
    @Parameter(property="versionRange", required=true)
    private String versionRange;
    @Parameter(property="printCE")
    private boolean printCE;
    @Parameter(property="printCCS")
    private boolean printCCS;
    @Parameter(property="includeSnapshots", defaultValue="false")
    private boolean includeSnapshots;
    @Parameter(property="resolver.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="resolver.newPomFile")
    private String newPomFile;
    @Parameter(property="failIfCCSNotfound", defaultValue="true")
    private boolean failIfCCSNotfound;
    @Parameter(property="failIfCENotfound", defaultValue="true")
    private boolean failIfCENotfound;
    @Parameter
    private String property;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    protected List<RemoteRepository> remoteRepositories;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!ResolveKafkaVersionRangeMojo.isVersionRange(this.versionRange)) {
            this.skip = true;
            this.getLog().info((CharSequence)"Skip version range resolve since property is not a valid range");
        }
        if (!this.skip) {
            VersionRangeRequest request = new VersionRangeRequest();
            request.setRepositories(this.remoteRepositories);
            DefaultArtifact artifact = new DefaultArtifact(this.groupId, this.artifactId, null, this.versionRange);
            request.setArtifact((Artifact)artifact);
            String constraintText = artifact.toString() + ", " + (this.includeSnapshots ? "including" : "excluding") + " snapshots";
            this.getLog().info((CharSequence)("Resolving range for " + constraintText));
            try {
                VersionRangeResult CEResult = this.repoSystem.resolveVersionRange(this.repoSession, request);
                VersionRangeResult CCSResult = this.repoSystem.resolveVersionRange(this.repoSession, request);
                String highestCEVersion = this.fetchHighestKafkaVersion(Strings.CE.toString(), CEResult, constraintText, this.failIfCENotfound);
                String highestCCSVersion = this.fetchHighestKafkaVersion(Strings.CCS.toString(), CCSResult, constraintText, this.failIfCCSNotfound);
                this.getLog().info((CharSequence)("Highest " + Strings.CE.toString() + " version: " + highestCEVersion));
                this.getLog().info((CharSequence)("Highest " + Strings.CCS.toString() + " version: " + highestCCSVersion));
                if (this.printCE) {
                    System.out.println(highestCEVersion);
                }
                if (this.printCCS) {
                    System.out.println(highestCCSVersion);
                }
                if (this.project != null) {
                    this.getLog().info((CharSequence)("Setting ce.kafka.version property ce.kafka.version=" + highestCEVersion));
                    this.project.getProperties().put(CE_KAFKA_VERSION, highestCEVersion);
                    this.getLog().info((CharSequence)("Setting kafka.version property kafka.version=" + highestCCSVersion));
                    this.project.getProperties().put(CCS_KAFKA_VERSION, highestCCSVersion);
                }
                if (this.newPomFile != null) {
                    this.createInstalledPom(highestCEVersion, highestCCSVersion);
                }
            }
            catch (VersionRangeResolutionException e) {
                throw new MojoExecutionException("", (Exception)((Object)e));
            }
        }
    }

    public String fetchHighestKafkaVersion(String kafkaType, VersionRangeResult result, String constraintText, boolean failIfNotFound) throws MojoExecutionException, MojoFailureException {
        try {
            this.getLog().debug((CharSequence)(kafkaType + " version fetched " + result.getVersions()));
            if (!this.includeSnapshots) {
                result.setVersions(this.removeSnapshots(result.getVersions()));
            }
            if (kafkaType.equals(Strings.CE.toString())) {
                result.setVersions(this.includeCE(result.getVersions()));
            } else if (kafkaType.equals(Strings.CCS.toString())) {
                result.setVersions(this.includeCCS(result.getVersions()));
            } else {
                throw new MojoFailureException("kafka type " + kafkaType + "wrong or not supported");
            }
            if (result.getVersions().isEmpty()) {
                this.getLog().warn((CharSequence)("Could not find any " + kafkaType + " artifacts."));
                if (failIfNotFound) {
                    throw new MojoFailureException("Could not find any " + kafkaType + " artifacts.");
                }
                this.getLog().warn((CharSequence)"Continuing with build because fail if not found for this version is set to false.");
                return "No Versions Found";
            }
            this.getLog().debug((CharSequence)(kafkaType + " Constraint: " + result.getVersionConstraint()));
            this.getLog().debug((CharSequence)(kafkaType + " Versions in range: " + result.getVersions()));
            Version highestVersion = result.getHighestVersion();
            if (highestVersion == null) {
                throw new MojoFailureException("No matching " + kafkaType + " version found for constraint: '" + constraintText + "'.");
            }
            return highestVersion.toString();
        }
        catch (MojoFailureException e) {
            throw new MojoExecutionException("", (Exception)((Object)e));
        }
    }

    private List<Version> removeSnapshots(List<Version> versions) {
        ArrayList<Version> result = new ArrayList<Version>();
        for (Version version : versions) {
            if (ResolveKafkaVersionRangeMojo.isSnapshot(version.toString())) continue;
            result.add(version);
        }
        return result;
    }

    private List<Version> includeCE(List<Version> versions) {
        ArrayList<Version> result = new ArrayList<Version>();
        for (Version version : versions) {
            if (!ResolveKafkaVersionRangeMojo.isCE(version.toString())) continue;
            result.add(version);
        }
        return result;
    }

    private List<Version> includeCCS(List<Version> versions) {
        ArrayList<Version> result = new ArrayList<Version>();
        for (Version version : versions) {
            if (!ResolveKafkaVersionRangeMojo.isCCS(version.toString())) continue;
            result.add(version);
        }
        return result;
    }

    public void createInstalledPom(String ceVersion, String ccsVersion) throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)"Creating installed pom file");
            File pomFile = this.project.getFile();
            Path installedPomPath = Paths.get(pomFile.getParent(), this.newPomFile);
            File installedPomFile = new File(installedPomPath.toString());
            StringBuilder input = PomHelper.readXmlFile((File)pomFile);
            ModifiedPomXMLEventReader newPom = this.newModifiedPomXER(input);
            if (!PomHelper.setPropertyVersion((ModifiedPomXMLEventReader)newPom, null, (String)CE_KAFKA_VERSION, (String)ceVersion)) {
                throw new MojoExecutionException("Failed to set ce.kafka.version property.");
            }
            if (!PomHelper.setPropertyVersion((ModifiedPomXMLEventReader)newPom, null, (String)CCS_KAFKA_VERSION, (String)ccsVersion)) {
                throw new MojoExecutionException("Failed to set kafka.version property.");
            }
            this.writeFile(installedPomFile, input);
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Failed to write installed pom file.", (Exception)e);
        }
        catch (XMLStreamException e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Failed to write installed pom file.", (Exception)e);
        }
    }

    protected final ModifiedPomXMLEventReader newModifiedPomXER(StringBuilder input) {
        ModifiedPomXMLEventReader newPom = null;
        try {
            XMLInputFactory inputFactory = XMLInputFactory2.newInstance();
            inputFactory.setProperty("org.codehaus.stax2.preserveLocation", Boolean.TRUE);
            newPom = new ModifiedPomXMLEventReader(input, inputFactory);
        }
        catch (XMLStreamException e) {
            this.getLog().error((Throwable)e);
        }
        return newPom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void writeFile(File outFile, StringBuilder input) throws IOException {
        XmlStreamWriter writer = WriterFactory.newXmlWriter((File)outFile);
        try {
            IOUtil.copy((String)input.toString(), (Writer)writer);
        }
        finally {
            IOUtil.close((Writer)writer);
        }
    }

    private static boolean isSnapshot(String version) {
        return version.endsWith(Strings.SNAPSHOT.toString()) || SNAPSHOT_TIMESTAMP.matcher(version).matches();
    }

    private static boolean isCCS(String version) {
        return version.endsWith(Strings.CCS_QUALIFIER.toString());
    }

    private static boolean isCE(String version) {
        return version.endsWith(Strings.CE_QUALIFIER.toString());
    }

    private static boolean isVersionRange(String versionRange) {
        boolean startValid = versionRange.startsWith("[") || versionRange.startsWith("(");
        boolean endValid = versionRange.endsWith("]") || versionRange.endsWith(")");
        return startValid && endValid;
    }

    static enum Strings {
        CE("ce-kafka"),
        CCS("ccs-kafka"),
        SNAPSHOT("SNAPSHOT"),
        CE_QUALIFIER("-ce"),
        CCS_QUALIFIER("-ccs");

        private final String text;

        private Strings(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

