/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.sql.impl;

import io.cloudevents.sql.EvaluationException;
import io.cloudevents.sql.ExceptionFactory;
import org.antlr.v4.runtime.misc.Interval;

public class ExceptionFactoryImpl
implements ExceptionFactory {
    private final boolean shouldThrow;

    public ExceptionFactoryImpl(boolean shouldThrow) {
        this.shouldThrow = shouldThrow;
    }

    @Override
    public EvaluationException.EvaluationExceptionFactory invalidCastTarget(Class<?> from, Class<?> to) {
        return (interval, expression) -> {
            EvaluationException exception = new EvaluationException(EvaluationException.ErrorKind.CAST, interval, expression, "Cannot cast " + from + " to " + to + ": no cast defined.", null);
            if (this.shouldThrow) {
                throw exception;
            }
            return exception;
        };
    }

    @Override
    public EvaluationException.EvaluationExceptionFactory castError(Class<?> from, Class<?> to, Throwable cause) {
        return (interval, expression) -> {
            EvaluationException exception = new EvaluationException(EvaluationException.ErrorKind.CAST, interval, expression, "Cannot cast " + from + " to " + to + ": " + cause.getMessage(), cause);
            if (this.shouldThrow) {
                throw exception;
            }
            return exception;
        };
    }

    @Override
    public EvaluationException missingAttribute(Interval interval, String expression, String key) {
        EvaluationException exception = new EvaluationException(EvaluationException.ErrorKind.MISSING_ATTRIBUTE, interval, expression, "Missing attribute " + key + " in the input event. Perhaps you should check with 'EXISTS " + key + "' if the input contains the provided key?", null);
        if (this.shouldThrow) {
            throw exception;
        }
        return exception;
    }

    @Override
    public EvaluationException cannotDispatchFunction(Interval interval, String expression, String functionName, Throwable cause) {
        EvaluationException exception = new EvaluationException(EvaluationException.ErrorKind.MISSING_FUNCTION, interval, expression, "Cannot dispatch function invocation to function " + functionName + ": " + cause.getMessage(), cause);
        if (this.shouldThrow) {
            throw exception;
        }
        return exception;
    }

    @Override
    public EvaluationException.EvaluationExceptionFactory functionExecutionError(String functionName, Throwable cause) {
        return (interval, expression) -> {
            EvaluationException exception = new EvaluationException(EvaluationException.ErrorKind.FUNCTION_EVALUATION, interval, expression, "Error while executing " + functionName + ": " + cause.getMessage(), cause);
            if (this.shouldThrow) {
                throw exception;
            }
            return exception;
        };
    }

    @Override
    public EvaluationException divisionByZero(Interval interval, String expression, Integer dividend) {
        return this.mathError(interval, expression, "Division by zero: " + dividend + " / 0");
    }

    @Override
    public EvaluationException mathError(Interval interval, String expression, String errorMessage) {
        EvaluationException exception = new EvaluationException(EvaluationException.ErrorKind.MATH, interval, expression, errorMessage, null);
        if (this.shouldThrow) {
            throw exception;
        }
        return exception;
    }
}

