/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.sql;

import org.antlr.v4.runtime.misc.Interval;

public class EvaluationException
extends RuntimeException {
    private final ErrorKind errorKind;
    private final Interval interval;
    private final String expression;

    public EvaluationException(ErrorKind errorKind, Interval interval, String expression, String message, Throwable cause) {
        super(String.format("%s at %s `%s`: %s", errorKind.name(), interval.toString(), expression, message), cause);
        this.errorKind = errorKind;
        this.interval = interval;
        this.expression = expression;
    }

    public ErrorKind getKind() {
        return this.errorKind;
    }

    public Interval getExpressionInterval() {
        return this.interval;
    }

    public String getExpressionText() {
        return this.expression;
    }

    public static enum ErrorKind {
        INVALID_CAST,
        MISSING_ATTRIBUTE,
        FUNCTION_DISPATCH,
        FUNCTION_EXECUTION,
        MATH;

    }

    @FunctionalInterface
    public static interface EvaluationExceptionFactory {
        public EvaluationException create(Interval var1, String var2);
    }
}

