/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.sql.impl;

import io.cloudevents.sql.EvaluationContext;
import io.cloudevents.sql.EvaluationRuntime;
import io.cloudevents.sql.Function;
import io.cloudevents.sql.Type;
import io.cloudevents.sql.impl.FunctionTable;
import io.cloudevents.sql.impl.TypeCastingProvider;

public class EvaluationRuntimeImpl
implements EvaluationRuntime {
    private final TypeCastingProvider typeCastingProvider;
    private final FunctionTable functionTable;

    public static EvaluationRuntime getInstance() {
        return SingletonContainer.INSTANCE;
    }

    public EvaluationRuntimeImpl(TypeCastingProvider typeCastingProvider, FunctionTable functionTable) {
        this.typeCastingProvider = typeCastingProvider;
        this.functionTable = functionTable;
    }

    @Override
    public boolean canCast(Object value, Type target) {
        return this.typeCastingProvider.canCast(value, target);
    }

    @Override
    public Object cast(EvaluationContext ctx, Object value, Type target) {
        return this.typeCastingProvider.cast(ctx, value, target);
    }

    @Override
    public Function resolveFunction(String name, int args) throws IllegalStateException {
        return this.functionTable.resolve(name, args);
    }

    private static class SingletonContainer {
        private static final EvaluationRuntimeImpl INSTANCE = new EvaluationRuntimeImpl(new TypeCastingProvider(), FunctionTable.getDefaultInstance());

        private SingletonContainer() {
        }
    }
}

