/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.spring.webflux;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.message.MessageReader;
import io.cloudevents.spring.http.CloudEventHttpUtils;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpInputMessage;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.util.StreamUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CloudEventHttpMessageReader
implements HttpMessageReader<CloudEvent> {
    public List<MediaType> getReadableMediaTypes() {
        return Arrays.asList(MediaType.APPLICATION_OCTET_STREAM, MediaType.ALL);
    }

    public boolean canRead(ResolvableType elementType, MediaType mediaType) {
        return CloudEvent.class.isAssignableFrom(elementType.toClass());
    }

    public Flux<CloudEvent> read(ResolvableType elementType, ReactiveHttpInputMessage message, Map<String, Object> hints) {
        return Flux.from(this.readMono(elementType, message, hints));
    }

    public Mono<CloudEvent> readMono(ResolvableType elementType, ReactiveHttpInputMessage message, Map<String, Object> hints) {
        HttpHeaders headers = message.getHeaders();
        Mono body = DataBufferUtils.join((Publisher)message.getBody()).map(buffer -> {
            try (InputStream inputStream = buffer.asInputStream(true);){
                byte[] byArray = StreamUtils.copyToByteArray((InputStream)inputStream);
                return byArray;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        });
        return body.map(bytes -> CloudEventHttpUtils.toReader(headers, () -> bytes)).map(MessageReader::toEvent);
    }
}

