/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.spring.codec;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.provider.EventFormatProvider;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.AbstractSingleValueEncoder;
import org.springframework.core.codec.Hints;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import reactor.core.publisher.Flux;

public class CloudEventEncoder
extends AbstractSingleValueEncoder<CloudEvent> {
    public CloudEventEncoder() {
        super(EventFormatProvider.getInstance().getContentTypes().stream().map(type -> MimeTypeUtils.parseMimeType((String)type)).collect(Collectors.toList()).toArray(new MimeType[0]));
    }

    public boolean canEncode(ResolvableType elementType, @Nullable MimeType mimeType) {
        Class clazz = elementType.toClass();
        return super.canEncode(elementType, mimeType) && CloudEvent.class.isAssignableFrom(clazz) && EventFormatProvider.getInstance().resolveFormat(mimeType.toString()) != null;
    }

    protected Flux<DataBuffer> encode(CloudEvent event, DataBufferFactory bufferFactory, ResolvableType type, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        return Flux.just((Object)this.encodeValue(event, bufferFactory, type, mimeType, hints));
    }

    public DataBuffer encodeValue(CloudEvent event, DataBufferFactory bufferFactory, ResolvableType valueType, MimeType mimeType, Map<String, Object> hints) {
        if (this.logger.isDebugEnabled() && !Hints.isLoggingSuppressed(hints)) {
            String logPrefix = Hints.getLogPrefix(hints);
            this.logger.debug((Object)(logPrefix + "Writing [" + event + "]"));
        }
        EventFormat format = EventFormatProvider.getInstance().resolveFormat(mimeType.toString());
        return bufferFactory.wrap(format.serialize(event));
    }
}

