/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.v03;

import io.cloudevents.core.v03.CloudEventBuilder;
import io.cloudevents.rw.CloudEventAttributesWriter;
import io.cloudevents.rw.CloudEventRWException;
import io.cloudevents.types.Time;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.OffsetDateTime;

class V1ToV03AttributesConverter
implements CloudEventAttributesWriter {
    private final CloudEventBuilder builder;

    V1ToV03AttributesConverter(CloudEventBuilder builder) {
        this.builder = builder;
    }

    public V1ToV03AttributesConverter withAttribute(String name, String value) throws CloudEventRWException {
        switch (name) {
            case "id": {
                this.builder.withId(value);
                return this;
            }
            case "source": {
                try {
                    this.builder.withSource(new URI(value));
                }
                catch (URISyntaxException e) {
                    throw CloudEventRWException.newInvalidAttributeValue((String)"source", (Object)value, (Throwable)e);
                }
                return this;
            }
            case "type": {
                this.builder.withType(value);
                return this;
            }
            case "datacontenttype": {
                this.builder.withDataContentType(value);
                return this;
            }
            case "dataschema": {
                try {
                    this.builder.withSchemaUrl(new URI(value));
                }
                catch (URISyntaxException e) {
                    throw CloudEventRWException.newInvalidAttributeValue((String)"dataschema", (Object)value, (Throwable)e);
                }
                return this;
            }
            case "subject": {
                this.builder.withSubject(value);
                return this;
            }
            case "time": {
                this.builder.withTime(Time.parseTime((String)"time", (String)value));
                return this;
            }
        }
        throw CloudEventRWException.newInvalidAttributeName((String)name);
    }

    public V1ToV03AttributesConverter withAttribute(String name, URI value) throws CloudEventRWException {
        switch (name) {
            case "source": {
                this.builder.withSource(value);
                return this;
            }
            case "dataschema": {
                this.builder.withSchemaUrl(value);
                return this;
            }
        }
        throw CloudEventRWException.newInvalidAttributeType((String)name, URI.class);
    }

    public V1ToV03AttributesConverter withAttribute(String name, OffsetDateTime value) throws CloudEventRWException {
        if ("time".equals(name)) {
            this.builder.withTime(value);
            return this;
        }
        throw CloudEventRWException.newInvalidAttributeType((String)name, OffsetDateTime.class);
    }
}

