/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.v03;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.cloudevents.Attributes;
import io.cloudevents.json.ZonedDateTimeDeserializer;
import io.cloudevents.v03.ContextAttributes;
import java.net.URI;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
public class AttributesImpl
implements Attributes {
    @NotBlank
    private final String id;
    @NotNull
    private final URI source;
    @NotBlank
    @Pattern(regexp="0\\.3")
    private final @NotBlank @Pattern(regexp="0\\.3") String specversion;
    @NotBlank
    private final String type;
    @JsonDeserialize(using=ZonedDateTimeDeserializer.class)
    private final ZonedDateTime time;
    private final URI schemaurl;
    @Pattern(regexp="base64")
    private final @Pattern(regexp="base64") String datacontentencoding;
    private final String datacontenttype;
    @Size(min=1)
    private final @Size(min=1) String subject;

    AttributesImpl(String id, URI source, String specversion, String type, ZonedDateTime time, URI schemaurl, String datacontentencoding, String datacontenttype, String subject) {
        this.id = id;
        this.source = source;
        this.specversion = specversion;
        this.type = type;
        this.time = time;
        this.schemaurl = schemaurl;
        this.datacontentencoding = datacontentencoding;
        this.datacontenttype = datacontenttype;
        this.subject = subject;
    }

    public String getId() {
        return this.id;
    }

    public URI getSource() {
        return this.source;
    }

    public String getSpecversion() {
        return this.specversion;
    }

    public String getType() {
        return this.type;
    }

    public Optional<ZonedDateTime> getTime() {
        return Optional.ofNullable(this.time);
    }

    public Optional<URI> getSchemaurl() {
        return Optional.ofNullable(this.schemaurl);
    }

    public Optional<String> getDatacontentencoding() {
        return Optional.ofNullable(this.datacontentencoding);
    }

    public Optional<String> getDatacontenttype() {
        return Optional.ofNullable(this.datacontenttype);
    }

    @Override
    public Optional<String> getMediaType() {
        return this.getDatacontenttype();
    }

    public Optional<String> getSubject() {
        return Optional.ofNullable(this.subject);
    }

    public String toString() {
        return "AttributesImpl [id=" + this.id + ", source=" + this.source + ", specversion=" + this.specversion + ", type=" + this.type + ", time=" + this.time + ", schemaurl=" + this.schemaurl + ", datacontentencoding=" + this.datacontentencoding + ", datacontenttype=" + this.datacontenttype + ", subject=" + this.subject + "]";
    }

    @JsonCreator
    public static AttributesImpl build(@JsonProperty(value="id") String id, @JsonProperty(value="source") URI source, @JsonProperty(value="specversion") String specversion, @JsonProperty(value="type") String type, @JsonProperty(value="time") ZonedDateTime time, @JsonProperty(value="schemaurl") URI schemaurl, @JsonProperty(value="datacontentenconding") String datacontentencoding, @JsonProperty(value="datacontenttype") String datacontenttype, @JsonProperty(value="subject") String subject) {
        return new AttributesImpl(id, source, specversion, type, time, schemaurl, datacontentencoding, datacontenttype, subject);
    }

    public static Map<String, String> marshal(AttributesImpl attributes) {
        Objects.requireNonNull(attributes);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(ContextAttributes.type.name(), attributes.getType());
        result.put(ContextAttributes.specversion.name(), attributes.getSpecversion());
        result.put(ContextAttributes.source.name(), attributes.getSource().toString());
        result.put(ContextAttributes.id.name(), attributes.getId());
        attributes.getTime().ifPresent(value -> result.put(ContextAttributes.time.name(), value.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME)));
        attributes.getSchemaurl().ifPresent(schema -> result.put(ContextAttributes.schemaurl.name(), schema.toString()));
        attributes.getDatacontenttype().ifPresent(ct -> result.put(ContextAttributes.datacontenttype.name(), (String)ct));
        attributes.getDatacontentencoding().ifPresent(dce -> result.put(ContextAttributes.datacontentencoding.name(), (String)dce));
        attributes.getSubject().ifPresent(subject -> result.put(ContextAttributes.subject.name(), (String)subject));
        return result;
    }

    public static AttributesImpl unmarshal(Map<String, String> attributes) {
        String type = attributes.get(ContextAttributes.type.name());
        ZonedDateTime time = Optional.ofNullable(attributes.get(ContextAttributes.time.name())).map(t -> ZonedDateTime.parse(t, DateTimeFormatter.ISO_ZONED_DATE_TIME)).orElse(null);
        String specversion = attributes.get(ContextAttributes.specversion.name());
        URI source = URI.create(attributes.get(ContextAttributes.source.name()));
        URI schemaurl = Optional.ofNullable(attributes.get(ContextAttributes.schemaurl.name())).map(schema -> URI.create(schema)).orElse(null);
        String id = attributes.get(ContextAttributes.id.name());
        String datacontenttype = attributes.get(ContextAttributes.datacontenttype.name());
        String datacontentencoding = attributes.get(ContextAttributes.datacontentencoding.name());
        String subject = attributes.get(ContextAttributes.subject.name());
        return AttributesImpl.build(id, source, specversion, type, time, schemaurl, datacontentencoding, datacontenttype, subject);
    }
}

