/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.v03;

import io.cloudevents.CloudEvent;
import io.cloudevents.extensions.ExtensionFormat;
import io.cloudevents.fun.EventBuilder;
import io.cloudevents.v03.Accessor;
import io.cloudevents.v03.AttributesImpl;
import io.cloudevents.v03.CloudEventImpl;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Validation;
import javax.validation.Validator;

public final class CloudEventBuilder<T>
implements EventBuilder<T, AttributesImpl> {
    private static Validator VALIDATOR;
    public static final String SPEC_VERSION = "0.3";
    private static final String MESSAGE_SEPARATOR = ", ";
    private static final String MESSAGE = "'%s' %s";
    private static final String ERR_MESSAGE = "invalid payload: %s";
    private String id;
    private URI source;
    private String type;
    private ZonedDateTime time;
    private URI schemaurl;
    private String datacontentencoding;
    private String datacontenttype;
    private String subject;
    private T data;
    private final Set<ExtensionFormat> extensions = new HashSet<ExtensionFormat>();

    private CloudEventBuilder() {
    }

    private static Validator getValidator() {
        if (null == VALIDATOR) {
            VALIDATOR = Validation.buildDefaultValidatorFactory().getValidator();
        }
        return VALIDATOR;
    }

    public static <T> CloudEventBuilder<T> builder() {
        return new CloudEventBuilder<T>();
    }

    public static <T> CloudEventBuilder<T> builder(CloudEvent<AttributesImpl, T> base) {
        Objects.requireNonNull(base);
        CloudEventBuilder result = new CloudEventBuilder();
        AttributesImpl attributes = base.getAttributes();
        result.withId(attributes.getId()).withSource(attributes.getSource()).withType(attributes.getType());
        attributes.getTime().ifPresent(time -> result.withTime((ZonedDateTime)time));
        attributes.getSchemaurl().ifPresent(schema -> result.withSchemaurl((URI)schema));
        attributes.getDatacontenttype().ifPresent(dc -> result.withDatacontenttype((String)dc));
        attributes.getDatacontentencoding().ifPresent(dce -> result.withDatacontentencoding((String)dce));
        attributes.getSubject().ifPresent(subject -> result.withSubject((String)subject));
        Accessor.extensionsOf(base).forEach(extension -> result.withExtension((ExtensionFormat)extension));
        base.getData().ifPresent(data -> result.withData(data));
        return result;
    }

    public static <T> CloudEventImpl<T> of(T data, AttributesImpl attributes, Collection<ExtensionFormat> extensions) {
        CloudEventBuilder builder = CloudEventBuilder.builder().withId(attributes.getId()).withSource(attributes.getSource()).withType(attributes.getType());
        attributes.getTime().ifPresent(time -> builder.withTime((ZonedDateTime)time));
        attributes.getSchemaurl().ifPresent(schemaurl -> builder.withSchemaurl((URI)schemaurl));
        attributes.getDatacontentencoding().ifPresent(dce -> builder.withDatacontentencoding((String)dce));
        attributes.getDatacontenttype().ifPresent(dct -> builder.withDatacontenttype((String)dct));
        attributes.getSubject().ifPresent(subject -> builder.withSubject((String)subject));
        extensions.stream().forEach(extension -> builder.withExtension((ExtensionFormat)extension));
        builder.withData(data);
        return builder.build();
    }

    @Override
    public CloudEvent<AttributesImpl, T> build(T data, AttributesImpl attributes, Collection<ExtensionFormat> extensions) {
        return CloudEventBuilder.of(data, attributes, extensions);
    }

    public CloudEventImpl<T> build() {
        AttributesImpl attributes = new AttributesImpl(this.id, this.source, SPEC_VERSION, this.type, this.time, this.schemaurl, this.datacontentencoding, this.datacontenttype, this.subject);
        CloudEventImpl<T> cloudEvent = new CloudEventImpl<T>(attributes, this.data, this.extensions);
        Set violations = CloudEventBuilder.getValidator().validate(cloudEvent, new Class[0]);
        violations.addAll(CloudEventBuilder.getValidator().validate((Object)cloudEvent.getAttributes(), new Class[0]));
        String errs = violations.stream().map(v -> String.format(MESSAGE, v.getPropertyPath(), v.getMessage())).collect(Collectors.joining(MESSAGE_SEPARATOR));
        Optional.ofNullable("".equals(errs) ? null : errs).ifPresent(e -> {
            throw new IllegalStateException(String.format(ERR_MESSAGE, e));
        });
        return cloudEvent;
    }

    public CloudEventBuilder<T> withId(String id) {
        this.id = id;
        return this;
    }

    public CloudEventBuilder<T> withSource(URI source) {
        this.source = source;
        return this;
    }

    public CloudEventBuilder<T> withType(String type) {
        this.type = type;
        return this;
    }

    public CloudEventBuilder<T> withTime(ZonedDateTime time) {
        this.time = time;
        return this;
    }

    public CloudEventBuilder<T> withSchemaurl(URI schemaurl) {
        this.schemaurl = schemaurl;
        return this;
    }

    public CloudEventBuilder<T> withDatacontentencoding(String datacontentencoding) {
        this.datacontentencoding = datacontentencoding;
        return this;
    }

    public CloudEventBuilder<T> withDatacontenttype(String datacontenttype) {
        this.datacontenttype = datacontenttype;
        return this;
    }

    public CloudEventBuilder<T> withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public CloudEventBuilder<T> withData(T data) {
        this.data = data;
        return this;
    }

    public CloudEventBuilder<T> withExtension(ExtensionFormat extension) {
        this.extensions.add(extension);
        return this;
    }
}

