/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents;

import java.util.HashMap;
import java.util.Map;

public enum SpecVersion {
    V_01("0.1"),
    V_02("0.2"),
    DEFAULT(V_02.toString());

    private final String version;
    private static final Map<String, SpecVersion> VERSION_TO_SPEC;

    private SpecVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return this.version;
    }

    public String version() {
        return this.version;
    }

    public static SpecVersion fromVersion(String version) {
        if (version == null) {
            return null;
        }
        SpecVersion specVersion = VERSION_TO_SPEC.get(version);
        if (specVersion == null) {
            throw new IllegalArgumentException();
        }
        return specVersion;
    }

    static {
        VERSION_TO_SPEC = new HashMap<String, SpecVersion>();
        SpecVersion[] instances = (SpecVersion[])SpecVersion.class.getEnumConstants();
        for (int i = 0; i < instances.length; ++i) {
            VERSION_TO_SPEC.put(instances[i].toString(), instances[i]);
        }
    }
}

