/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration.to_8_6;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbInt;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.protocol.ZbColumnFamilies;

public class DbDistributionMigrationState {
    private final ColumnFamily<DbCompositeKey<DbForeignKey<DbLong>, DbInt>, DbNil> pendingDistributionColumnFamily;
    private final ColumnFamily<DbCompositeKey<DbForeignKey<DbLong>, DbInt>, DbNil> retriableDistributionColumnFamily;
    private final DbLong distributionKey = new DbLong();
    private final DbInt partitionKey;
    private final DbCompositeKey<DbForeignKey<DbLong>, DbInt> distributionPartitionKey;

    public DbDistributionMigrationState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        DbForeignKey fkDistribution = new DbForeignKey((DbKey)this.distributionKey, (Enum)ZbColumnFamilies.COMMAND_DISTRIBUTION_RECORD);
        this.partitionKey = new DbInt();
        this.distributionPartitionKey = new DbCompositeKey((DbKey)fkDistribution, (DbKey)this.partitionKey);
        this.pendingDistributionColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.PENDING_DISTRIBUTION, transactionContext, this.distributionPartitionKey, (DbValue)DbNil.INSTANCE);
        this.retriableDistributionColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.RETRIABLE_DISTRIBUTION, transactionContext, this.distributionPartitionKey, (DbValue)DbNil.INSTANCE);
    }

    public void migratePendingDistributionsToRetriableDistributions() {
        this.pendingDistributionColumnFamily.forEach((arg_0, arg_1) -> this.retriableDistributionColumnFamily.insert(arg_0, arg_1));
    }

    public boolean existsPendingDistribution(long distributionKey, int partitionId) {
        this.distributionKey.wrapLong(distributionKey);
        this.partitionKey.wrapInt(partitionId);
        return this.pendingDistributionColumnFamily.exists(this.distributionPartitionKey);
    }

    public boolean existsRetriableDistribution(long distributionKey, int partitionId) {
        this.distributionKey.wrapLong(distributionKey);
        this.partitionKey.wrapInt(partitionId);
        return this.retriableDistributionColumnFamily.exists(this.distributionPartitionKey);
    }
}

