/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration.to_8_5.corrections;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbBytes;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.db.impl.ZeebeDbConstants;
import io.camunda.zeebe.engine.state.migration.DbMigratorImpl;
import io.camunda.zeebe.engine.state.migration.MigrationTaskState;
import io.camunda.zeebe.engine.state.migration.to_8_5.corrections.ColumnFamilyCorrectionException;
import io.camunda.zeebe.engine.state.signal.SignalSubscription;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ColumnFamily50Corrector {
    private static final Logger LOG = LoggerFactory.getLogger((String)DbMigratorImpl.class.getPackageName());
    private static final ZbColumnFamilies CF_UNDER_RECOVERY = ZbColumnFamilies.DEPRECATED_SIGNAL_SUBSCRIPTION_BY_NAME_AND_KEY;
    private static final ZbColumnFamilies CF_POSSIBLE_TARGET = ZbColumnFamilies.MIGRATIONS_STATE;
    private final ColumnFamily<DbBytes, DbBytes> recoverySignalNameAndSubscriptionKeyColumnFamily;
    private final SignalSubscription signalSubscription = new SignalSubscription();
    private final DbLong subscriptionKey;
    private final DbString signalName;
    private final DbString migrationIdentifier;
    private final MigrationTaskState migrationTaskState;
    private final ColumnFamily<DbString, MigrationTaskState> migrationStateColumnFamily;

    public ColumnFamily50Corrector(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.recoverySignalNameAndSubscriptionKeyColumnFamily = zeebeDb.createColumnFamily((Enum)CF_UNDER_RECOVERY, transactionContext, (DbKey)new DbBytes(), (DbValue)new DbBytes());
        this.subscriptionKey = new DbLong();
        this.signalName = new DbString();
        this.migrationIdentifier = new DbString();
        this.migrationTaskState = new MigrationTaskState();
        this.migrationStateColumnFamily = zeebeDb.createColumnFamily((Enum)CF_POSSIBLE_TARGET, transactionContext, (DbKey)this.migrationIdentifier, (DbValue)this.migrationTaskState);
    }

    public void correctColumnFamilyPrefix() {
        this.recoverySignalNameAndSubscriptionKeyColumnFamily.forEach((key, value) -> {
            if (!ColumnFamily50Corrector.isKeyWithExpectedLength(key)) {
                LOG.trace("Found invalid key [{}] (incorrect key length) in column family [{}] {}", new Object[]{key, CF_UNDER_RECOVERY.ordinal(), CF_UNDER_RECOVERY.name()});
                this.tryMoveDataToMigrationStateColumnFamily((DbBytes)key, (DbBytes)value);
                return;
            }
            try {
                DbCompositeKey signalNameAndSubscriptionKey = new DbCompositeKey((DbKey)this.signalName, (DbKey)this.subscriptionKey);
                signalNameAndSubscriptionKey.wrap(key.getDirectBuffer(), 0, key.getLength());
            }
            catch (Exception e) {
                LOG.trace("Found invalid key [{}] (unable to read key) in column family [{}] {}", new Object[]{key, CF_UNDER_RECOVERY.ordinal(), CF_UNDER_RECOVERY.name()});
                this.tryMoveDataToMigrationStateColumnFamily((DbBytes)key, (DbBytes)value);
                return;
            }
            try {
                this.signalSubscription.wrap(value.getDirectBuffer(), 0, value.getLength());
            }
            catch (Exception e) {
                LOG.trace("Found invalid value [{}] (unable to read value) in column family [{}] {}", new Object[]{value, CF_UNDER_RECOVERY.ordinal(), CF_UNDER_RECOVERY.name()});
                this.tryMoveDataToMigrationStateColumnFamily((DbBytes)key, (DbBytes)value);
                return;
            }
            if (value.getLength() != this.signalSubscription.getLength()) {
                LOG.trace("Found invalid value [{}] (incorrect value length) in column family [{}] {}", new Object[]{value, CF_UNDER_RECOVERY.ordinal(), CF_UNDER_RECOVERY.name()});
                this.tryMoveDataToMigrationStateColumnFamily((DbBytes)key, (DbBytes)value);
                return;
            }
            LOG.trace("Found valid signal subscription entry with key[{}] in recovery column family", key);
        });
    }

    private static boolean isKeyWithExpectedLength(DbBytes key) {
        int stringLength = key.getDirectBuffer().getInt(0, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        return key.getLength() == 4 + stringLength + 8;
    }

    private void tryMoveDataToMigrationStateColumnFamily(DbBytes key, DbBytes value) {
        MigrationTaskState currentState;
        try {
            this.migrationIdentifier.wrap(key.getDirectBuffer(), 0, key.getLength());
            this.migrationTaskState.wrap(value.getDirectBuffer(), 0, value.getLength());
        }
        catch (Exception e) {
            String reason = "unexpected data in column family";
            throw new ColumnFamilyCorrectionException("unexpected data in column family", key, value, CF_UNDER_RECOVERY, e);
        }
        if (this.migrationTaskState.getState() == MigrationTaskState.State.NOT_STARTED && (currentState = (MigrationTaskState)this.migrationStateColumnFamily.get((DbKey)this.migrationIdentifier)) != null && currentState.getState() == MigrationTaskState.State.FINISHED) {
            this.deleteEntryFromRecoveryColumnFamily(key);
            return;
        }
        this.moveEntryFromRecoveryColumnFamilyToMigrationStateColumnFamily(key, this.migrationIdentifier, this.migrationTaskState);
    }

    private void moveEntryFromRecoveryColumnFamilyToMigrationStateColumnFamily(DbBytes key, DbString migrationIdentifier, MigrationTaskState migrationTaskState) {
        LOG.debug("Copying entry with key[{}] from column family [{}] {} to column family [{}] {}", new Object[]{key, CF_UNDER_RECOVERY.ordinal(), CF_UNDER_RECOVERY.name(), CF_POSSIBLE_TARGET.ordinal(), CF_POSSIBLE_TARGET.name()});
        this.migrationStateColumnFamily.upsert((DbKey)migrationIdentifier, (DbValue)migrationTaskState);
        this.deleteEntryFromRecoveryColumnFamily(key);
    }

    private void deleteEntryFromRecoveryColumnFamily(DbBytes key) {
        LOG.debug("Deleting entry with key[{}] from column family [{}] {}", new Object[]{key, CF_UNDER_RECOVERY.ordinal(), CF_UNDER_RECOVERY.name()});
        this.recoverySignalNameAndSubscriptionKeyColumnFamily.deleteExisting((DbKey)key);
    }
}

