/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration.to_8_3;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.db.impl.DbTenantAwareKey;
import io.camunda.zeebe.engine.state.deployment.Digest;
import io.camunda.zeebe.engine.state.deployment.PersistedProcess;
import io.camunda.zeebe.engine.state.deployment.VersionInfo;
import io.camunda.zeebe.engine.state.migration.MemoryBoundedColumnIteration;
import io.camunda.zeebe.protocol.ZbColumnFamilies;

public final class DbProcessMigrationState {
    private final DbLong processDefinitionKey = new DbLong();
    private final PersistedProcess persistedProcess = new PersistedProcess();
    private final ColumnFamily<DbLong, PersistedProcess> deprecatedProcessCacheColumnFamily;
    private final DbString tenantIdKey;
    private final DbTenantAwareKey<DbLong> tenantAwareProcessDefinitionKey;
    private final ColumnFamily<DbTenantAwareKey<DbLong>, PersistedProcess> processColumnFamily;
    private final DbString processId;
    private final DbLong processVersion;
    private final DbCompositeKey<DbString, DbLong> idAndVersionKey;
    private final ColumnFamily<DbCompositeKey<DbString, DbLong>, PersistedProcess> deprecatedProcessCacheByIdAndVersionColumnFamily;
    private final DbTenantAwareKey<DbCompositeKey<DbString, DbLong>> tenantAwareProcessIdAndVersionKey;
    private final ColumnFamily<DbTenantAwareKey<DbCompositeKey<DbString, DbLong>>, PersistedProcess> processByIdAndVersionColumnFamily;
    private final Digest digest;
    private final DbForeignKey<DbString> fkProcessId;
    private final ColumnFamily<DbForeignKey<DbString>, Digest> deprecatedDigestByIdColumnFamily;
    private final DbTenantAwareKey<DbString> tenantAwareProcessId;
    private final DbForeignKey<DbTenantAwareKey<DbString>> fkTenantAwareProcessId;
    private final ColumnFamily<DbForeignKey<DbTenantAwareKey<DbString>>, Digest> digestByIdColumnFamily;
    private final DbString processIdKey;
    private final VersionInfo versionInfo;
    private final ColumnFamily<DbString, VersionInfo> deprecatedProcessVersionColumnFamily;
    private final DbString idKey;
    private final DbTenantAwareKey<DbString> tenantAwareIdKey;
    private final ColumnFamily<DbTenantAwareKey<DbString>, VersionInfo> versionInfoColumnFamily;

    public DbProcessMigrationState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.deprecatedProcessCacheColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DEPRECATED_PROCESS_CACHE, transactionContext, (DbKey)this.processDefinitionKey, (DbValue)this.persistedProcess);
        this.tenantIdKey = new DbString();
        this.tenantAwareProcessDefinitionKey = new DbTenantAwareKey(this.tenantIdKey, (DbKey)this.processDefinitionKey, DbTenantAwareKey.PlacementType.PREFIX);
        this.processColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.PROCESS_CACHE, transactionContext, this.tenantAwareProcessDefinitionKey, (DbValue)this.persistedProcess);
        this.processId = new DbString();
        this.processVersion = new DbLong();
        this.idAndVersionKey = new DbCompositeKey((DbKey)this.processId, (DbKey)this.processVersion);
        this.deprecatedProcessCacheByIdAndVersionColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DEPRECATED_PROCESS_CACHE_BY_ID_AND_VERSION, transactionContext, this.idAndVersionKey, (DbValue)this.persistedProcess);
        this.tenantAwareProcessIdAndVersionKey = new DbTenantAwareKey(this.tenantIdKey, this.idAndVersionKey, DbTenantAwareKey.PlacementType.PREFIX);
        this.processByIdAndVersionColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.PROCESS_CACHE_BY_ID_AND_VERSION, transactionContext, this.tenantAwareProcessIdAndVersionKey, (DbValue)this.persistedProcess);
        this.digest = new Digest();
        this.fkProcessId = new DbForeignKey((DbKey)this.processId, (Enum)ZbColumnFamilies.DEPRECATED_PROCESS_CACHE_BY_ID_AND_VERSION, DbForeignKey.MatchType.Prefix);
        this.deprecatedDigestByIdColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DEPRECATED_PROCESS_CACHE_DIGEST_BY_ID, transactionContext, this.fkProcessId, (DbValue)this.digest);
        this.tenantAwareProcessId = new DbTenantAwareKey(this.tenantIdKey, (DbKey)this.processId, DbTenantAwareKey.PlacementType.PREFIX);
        this.fkTenantAwareProcessId = new DbForeignKey(this.tenantAwareProcessId, (Enum)ZbColumnFamilies.PROCESS_CACHE_BY_ID_AND_VERSION, DbForeignKey.MatchType.Prefix);
        this.digestByIdColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.PROCESS_CACHE_DIGEST_BY_ID, transactionContext, this.fkTenantAwareProcessId, (DbValue)this.digest);
        this.processIdKey = new DbString();
        this.versionInfo = new VersionInfo();
        this.deprecatedProcessVersionColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DEPRECATED_PROCESS_VERSION, transactionContext, (DbKey)this.processIdKey, (DbValue)this.versionInfo);
        this.idKey = new DbString();
        this.tenantAwareIdKey = new DbTenantAwareKey(this.tenantIdKey, (DbKey)this.idKey, DbTenantAwareKey.PlacementType.PREFIX);
        this.versionInfoColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.PROCESS_VERSION, transactionContext, this.tenantAwareIdKey, (DbValue)this.versionInfo);
    }

    public void migrateProcessStateForMultiTenancy() {
        MemoryBoundedColumnIteration iterator = new MemoryBoundedColumnIteration();
        this.tenantIdKey.wrapString("<default>");
        iterator.drain(this.deprecatedProcessCacheColumnFamily, (key, value) -> {
            value.setTenantId("<default>");
            this.processDefinitionKey.wrapLong(key.getValue());
            this.processColumnFamily.insert(this.tenantAwareProcessDefinitionKey, (DbValue)value);
        });
        iterator.drain(this.deprecatedProcessCacheByIdAndVersionColumnFamily, (key, value) -> {
            value.setTenantId("<default>");
            this.processId.wrapBuffer(value.getBpmnProcessId());
            this.processVersion.wrapLong((long)value.getVersion());
            this.processByIdAndVersionColumnFamily.insert(this.tenantAwareProcessIdAndVersionKey, (DbValue)value);
        });
        iterator.drain(this.deprecatedDigestByIdColumnFamily, (key, value) -> {
            this.processId.wrapBuffer(((DbString)key.inner()).getBuffer());
            this.digestByIdColumnFamily.insert(this.fkTenantAwareProcessId, (DbValue)value);
        });
        iterator.drain(this.deprecatedProcessVersionColumnFamily, (key, value) -> {
            this.idKey.wrapBuffer(key.getBuffer());
            long highestVersion = value.getHighestVersion();
            for (long version = 1L; version <= highestVersion; ++version) {
                if (value.getKnownVersions().contains(version)) continue;
                value.addKnownVersion(version);
            }
            this.versionInfoColumnFamily.insert(this.tenantAwareIdKey, (DbValue)value);
        });
    }
}

