/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.deployment;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.db.impl.DbTenantAwareKey;
import io.camunda.zeebe.engine.EngineConfiguration;
import io.camunda.zeebe.engine.state.deployment.PersistedResource;
import io.camunda.zeebe.engine.state.deployment.VersionManager;
import io.camunda.zeebe.engine.state.mutable.MutableResourceState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ResourceRecord;
import java.util.Optional;
import java.util.concurrent.ExecutionException;

public class DbResourceState
implements MutableResourceState {
    private static final int DEFAULT_VERSION_VALUE = 0;
    private final DbString tenantIdKey = new DbString();
    private final DbLong dbResourceKey = new DbLong();
    private final DbTenantAwareKey<DbLong> tenantAwareResourceKey = new DbTenantAwareKey(this.tenantIdKey, (DbKey)this.dbResourceKey, DbTenantAwareKey.PlacementType.PREFIX);
    private final DbForeignKey<DbTenantAwareKey<DbLong>> fkResourceKey = new DbForeignKey(this.tenantAwareResourceKey, (Enum)ZbColumnFamilies.RESOURCES);
    private final PersistedResource dbPersistedResource = new PersistedResource();
    private final ColumnFamily<DbTenantAwareKey<DbLong>, PersistedResource> resourcesByKey;
    private final DbString dbResourceId;
    private final VersionManager versionManager;
    private final DbLong resourceVersion;
    private final DbCompositeKey<DbString, DbLong> idAndVersionKey;
    private final DbTenantAwareKey<DbCompositeKey<DbString, DbLong>> tenantAwareIdAndVersionKey;
    private final ColumnFamily<DbTenantAwareKey<DbCompositeKey<DbString, DbLong>>, DbForeignKey<DbTenantAwareKey<DbLong>>> resourceByIdAndVersionColumnFamily;
    private final DbLong dbDeploymentKey;
    private final DbTenantAwareKey<DbCompositeKey<DbString, DbLong>> tenantAwareResourceIdAndDeploymentKey;
    private final ColumnFamily<DbTenantAwareKey<DbCompositeKey<DbString, DbLong>>, DbForeignKey<DbTenantAwareKey<DbLong>>> resourceKeyByResourceIdAndDeploymentKeyColumnFamily;
    private final DbString dbVersionTag;
    private final DbTenantAwareKey<DbCompositeKey<DbString, DbString>> tenantAwareResourceIdAndVersionTagKey;
    private final ColumnFamily<DbTenantAwareKey<DbCompositeKey<DbString, DbString>>, DbForeignKey<DbTenantAwareKey<DbLong>>> resourceKeyByResourceIdAndVersionTagColumnFamily;
    private final LoadingCache<TenantIdAndResourceId, PersistedResource> resourcesByTenantIdAndIdCache;

    public DbResourceState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext, EngineConfiguration config) {
        this.resourcesByKey = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.RESOURCES, transactionContext, this.tenantAwareResourceKey, (DbValue)this.dbPersistedResource);
        this.dbResourceId = new DbString();
        this.resourceVersion = new DbLong();
        this.idAndVersionKey = new DbCompositeKey((DbKey)this.dbResourceId, (DbKey)this.resourceVersion);
        this.tenantAwareIdAndVersionKey = new DbTenantAwareKey(this.tenantIdKey, this.idAndVersionKey, DbTenantAwareKey.PlacementType.PREFIX);
        this.resourceByIdAndVersionColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.RESOURCE_BY_ID_AND_VERSION, transactionContext, this.tenantAwareIdAndVersionKey, this.fkResourceKey);
        this.dbDeploymentKey = new DbLong();
        this.tenantAwareResourceIdAndDeploymentKey = new DbTenantAwareKey(this.tenantIdKey, (DbKey)new DbCompositeKey((DbKey)this.dbResourceId, (DbKey)this.dbDeploymentKey), DbTenantAwareKey.PlacementType.PREFIX);
        this.resourceKeyByResourceIdAndDeploymentKeyColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.RESOURCE_KEY_BY_RESOURCE_ID_AND_DEPLOYMENT_KEY, transactionContext, this.tenantAwareResourceIdAndDeploymentKey, this.fkResourceKey);
        this.dbVersionTag = new DbString();
        this.tenantAwareResourceIdAndVersionTagKey = new DbTenantAwareKey(this.tenantIdKey, (DbKey)new DbCompositeKey((DbKey)this.dbResourceId, (DbKey)this.dbVersionTag), DbTenantAwareKey.PlacementType.PREFIX);
        this.resourceKeyByResourceIdAndVersionTagColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.RESOURCE_KEY_BY_RESOURCE_ID_AND_VERSION_TAG, transactionContext, this.tenantAwareResourceIdAndVersionTagKey, this.fkResourceKey);
        this.versionManager = new VersionManager(0L, zeebeDb, ZbColumnFamilies.RESOURCE_VERSION, transactionContext);
        this.resourcesByTenantIdAndIdCache = CacheBuilder.newBuilder().maximumSize((long)config.getResourceCacheCapacity()).build((CacheLoader)new CacheLoader<TenantIdAndResourceId, PersistedResource>(){

            public PersistedResource load(TenantIdAndResourceId key) throws ResourceNotFoundException {
                return DbResourceState.this.getPersistedResourceById(key.resourceId, key.tenantId);
            }
        });
    }

    @Override
    public void storeResourceInResourceColumnFamily(ResourceRecord record) {
        this.tenantIdKey.wrapString(record.getTenantId());
        this.dbResourceKey.wrapLong(record.getResourceKey());
        this.dbPersistedResource.wrap(record);
        this.resourcesByKey.upsert(this.tenantAwareResourceKey, (DbValue)this.dbPersistedResource);
        this.resourcesByTenantIdAndIdCache.put((Object)new TenantIdAndResourceId(record.getTenantId(), record.getResourceId()), (Object)this.dbPersistedResource.copy());
    }

    @Override
    public void storeResourceInResourceByIdAndVersionColumnFamily(ResourceRecord record) {
        this.tenantIdKey.wrapString(record.getTenantId());
        this.dbResourceId.wrapString(record.getResourceId());
        this.resourceVersion.wrapLong((long)record.getVersion());
        this.dbPersistedResource.wrap(record);
        this.resourceByIdAndVersionColumnFamily.upsert(this.tenantAwareIdAndVersionKey, this.fkResourceKey);
    }

    @Override
    public void storeResourceInResourceKeyByResourceIdAndDeploymentKeyColumnFamily(ResourceRecord record) {
        this.tenantIdKey.wrapString(record.getTenantId());
        this.dbResourceKey.wrapLong(record.getResourceKey());
        this.dbResourceId.wrapString(record.getResourceId());
        this.dbDeploymentKey.wrapLong(record.getDeploymentKey());
        this.resourceKeyByResourceIdAndDeploymentKeyColumnFamily.upsert(this.tenantAwareResourceIdAndDeploymentKey, this.fkResourceKey);
    }

    @Override
    public void storeResourceInResourceKeyByResourceIdAndVersionTagColumnFamily(ResourceRecord record) {
        String versionTag = record.getVersionTag();
        if (!versionTag.isBlank()) {
            this.tenantIdKey.wrapString(record.getTenantId());
            this.dbResourceKey.wrapLong(record.getResourceKey());
            this.dbResourceId.wrapString(record.getResourceId());
            this.dbVersionTag.wrapString(versionTag);
            this.resourceKeyByResourceIdAndVersionTagColumnFamily.upsert(this.tenantAwareResourceIdAndVersionTagKey, this.fkResourceKey);
        }
    }

    @Override
    public void updateLatestVersion(ResourceRecord record) {
        this.versionManager.addResourceVersion(record.getResourceId(), record.getVersion(), record.getTenantId());
    }

    @Override
    public void deleteResourceInResourcesColumnFamily(ResourceRecord record) {
        this.tenantIdKey.wrapString(record.getTenantId());
        this.dbResourceKey.wrapLong(record.getResourceKey());
        this.resourcesByKey.deleteExisting(this.tenantAwareResourceKey);
        this.resourcesByTenantIdAndIdCache.invalidate((Object)new TenantIdAndResourceId(record.getTenantId(), record.getResourceId()));
    }

    @Override
    public void deleteResourceInResourceByIdAndVersionColumnFamily(ResourceRecord record) {
        this.tenantIdKey.wrapString(record.getTenantId());
        this.dbResourceId.wrapString(record.getResourceId());
        this.resourceVersion.wrapLong((long)record.getVersion());
        this.resourceByIdAndVersionColumnFamily.deleteExisting(this.tenantAwareIdAndVersionKey);
    }

    @Override
    public void deleteResourceInResourceVersionColumnFamily(ResourceRecord record) {
        this.versionManager.deleteResourceVersion(record.getResourceId(), record.getVersion(), record.getTenantId());
    }

    @Override
    public void deleteResourceInResourceKeyByResourceIdAndDeploymentKeyColumnFamily(ResourceRecord record) {
        this.tenantIdKey.wrapString(record.getTenantId());
        this.dbResourceId.wrapString(record.getResourceId());
        this.dbDeploymentKey.wrapLong(record.getDeploymentKey());
        this.resourceKeyByResourceIdAndDeploymentKeyColumnFamily.deleteIfExists(this.tenantAwareResourceIdAndDeploymentKey);
    }

    @Override
    public void deleteResourceInResourceKeyByResourceIdAndVersionTagColumnFamily(ResourceRecord record) {
        this.tenantIdKey.wrapString(record.getTenantId());
        this.dbResourceId.wrapString(record.getResourceId());
        this.dbVersionTag.wrapString(record.getVersionTag());
        this.resourceKeyByResourceIdAndVersionTagColumnFamily.deleteIfExists(this.tenantAwareResourceIdAndVersionTagKey);
    }

    @Override
    public Optional<PersistedResource> findLatestResourceById(String resourceId, String tenantId) {
        return this.getResourceFromCache(tenantId, resourceId);
    }

    @Override
    public Optional<PersistedResource> findResourceByKey(long resourceKey, String tenantId) {
        this.tenantIdKey.wrapString(tenantId);
        this.dbResourceKey.wrapLong(resourceKey);
        return Optional.ofNullable((PersistedResource)this.resourcesByKey.get(this.tenantAwareResourceKey)).map(PersistedResource::copy);
    }

    @Override
    public Optional<PersistedResource> findResourceByIdAndDeploymentKey(String resourceId, long deploymentKey, String tenantId) {
        this.tenantIdKey.wrapString(tenantId);
        this.dbResourceId.wrapString(resourceId);
        this.dbDeploymentKey.wrapLong(deploymentKey);
        return Optional.ofNullable((DbForeignKey)this.resourceKeyByResourceIdAndDeploymentKeyColumnFamily.get(this.tenantAwareResourceIdAndDeploymentKey)).flatMap(key -> this.findResourceByKey(((DbLong)((DbTenantAwareKey)key.inner()).wrappedKey()).getValue(), tenantId));
    }

    @Override
    public Optional<PersistedResource> findResourceByIdAndVersionTag(String resourceId, String versionTag, String tenantId) {
        this.tenantIdKey.wrapString(tenantId);
        this.dbResourceId.wrapString(resourceId);
        this.dbVersionTag.wrapString(versionTag);
        return Optional.ofNullable((DbForeignKey)this.resourceKeyByResourceIdAndVersionTagColumnFamily.get(this.tenantAwareResourceIdAndVersionTagKey)).flatMap(key -> this.findResourceByKey(((DbLong)((DbTenantAwareKey)key.inner()).wrappedKey()).getValue(), tenantId));
    }

    @Override
    public int getNextResourceVersion(String resourceId, String tenantId) {
        return (int)this.versionManager.getHighestResourceVersion(resourceId, tenantId) + 1;
    }

    @Override
    public void clearCache() {
        this.resourcesByTenantIdAndIdCache.invalidateAll();
        this.versionManager.clear();
    }

    private PersistedResource getPersistedResourceById(String resourceId, String tenantId) throws ResourceNotFoundException {
        this.dbResourceId.wrapString(resourceId);
        this.tenantIdKey.wrapString(tenantId);
        long latestVersion = this.versionManager.getLatestResourceVersion(resourceId, tenantId);
        this.resourceVersion.wrapLong(latestVersion);
        Optional<PersistedResource> persistedResource = Optional.ofNullable((DbForeignKey)this.resourceByIdAndVersionColumnFamily.get(this.tenantAwareIdAndVersionKey)).flatMap(key -> this.findResourceByKey(((DbLong)((DbTenantAwareKey)key.inner()).wrappedKey()).getValue(), tenantId));
        return persistedResource.map(PersistedResource::copy).orElseThrow(ResourceNotFoundException::new);
    }

    private Optional<PersistedResource> getResourceFromCache(String tenantId, String resourceId) {
        try {
            return Optional.of((PersistedResource)((Object)this.resourcesByTenantIdAndIdCache.get((Object)new TenantIdAndResourceId(tenantId, resourceId))));
        }
        catch (ExecutionException e) {
            return Optional.empty();
        }
    }

    private record TenantIdAndResourceId(String tenantId, String resourceId) {
    }

    private static final class ResourceNotFoundException
    extends Exception {
        private ResourceNotFoundException() {
        }
    }
}

