/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.resource;

import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.deployment.PersistedResource;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.engine.state.immutable.ResourceState;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ResourceRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ResourceIntent;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.List;
import java.util.Optional;

public class ResourceFetchProcessor
implements TypedRecordProcessor<ResourceRecord> {
    private final TypedResponseWriter responseWriter;
    private final TypedRejectionWriter rejectionWriter;
    private final StateWriter stateWriter;
    private final ResourceState resourceState;

    public ResourceFetchProcessor(Writers writers, ProcessingState processingState) {
        this.responseWriter = writers.response();
        this.rejectionWriter = writers.rejection();
        this.stateWriter = writers.state();
        this.resourceState = processingState.getResourceState();
    }

    @Override
    public void processRecord(TypedRecord<ResourceRecord> command) {
        long resourceKey = ((ResourceRecord)command.getValue()).getResourceKey();
        for (String tenantId : ResourceFetchProcessor.getAuthorizedTenants(command)) {
            Optional<PersistedResource> optionalResource = this.resourceState.findResourceByKey(resourceKey, tenantId);
            if (!optionalResource.isPresent()) continue;
            ResourceRecord record = ResourceFetchProcessor.asResourceRecord(optionalResource.get());
            this.stateWriter.appendFollowUpEvent(resourceKey, (Intent)ResourceIntent.FETCHED, (RecordValue)record);
            this.responseWriter.writeEventOnCommand(resourceKey, (Intent)ResourceIntent.FETCHED, (UnpackedObject)record, command);
            return;
        }
        throw new NoSuchResourceException(resourceKey);
    }

    @Override
    public TypedRecordProcessor.ProcessingError tryHandleError(TypedRecord<ResourceRecord> command, Throwable error) {
        if (error instanceof NoSuchResourceException) {
            NoSuchResourceException exception = (NoSuchResourceException)error;
            this.rejectionWriter.appendRejection(command, RejectionType.NOT_FOUND, exception.getMessage());
            this.responseWriter.writeRejectionOnCommand(command, RejectionType.NOT_FOUND, exception.getMessage());
            return TypedRecordProcessor.ProcessingError.EXPECTED_ERROR;
        }
        return TypedRecordProcessor.ProcessingError.UNEXPECTED_ERROR;
    }

    private static List<String> getAuthorizedTenants(TypedRecord<ResourceRecord> command) {
        return command.getAuthorizations().getOrDefault("authorized_tenants", List.of());
    }

    private static ResourceRecord asResourceRecord(PersistedResource resource) {
        return new ResourceRecord().setResource(BufferUtil.wrapString((String)resource.getResource())).setResourceKey(resource.getResourceKey()).setResourceId(resource.getResourceId()).setResourceName(resource.getResourceName()).setVersion(resource.getVersion()).setVersionTag(resource.getVersionTag()).setTenantId(resource.getTenantId()).setDeploymentKey(resource.getDeploymentKey()).setChecksum(resource.getChecksum());
    }

    private static final class NoSuchResourceException
    extends IllegalStateException {
        private static final String ERROR_MESSAGE_RESOURCE_NOT_FOUND = "Expected to fetch resource but no resource found with key `%d`";

        private NoSuchResourceException(long resourceKey) {
            super(String.format(ERROR_MESSAGE_RESOURCE_NOT_FOUND, resourceKey));
        }
    }
}

