/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance;

import io.camunda.zeebe.engine.processing.deployment.model.element.AbstractFlowElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableActivity;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableMultiInstanceBody;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceBatchRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceBatchIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.stream.api.state.KeyGenerator;

public final class ProcessInstanceBatchActivateProcessor
implements TypedRecordProcessor<ProcessInstanceBatchRecord> {
    public static final String PARENT_NOT_FOUND_ERROR_MESSAGE = "Expected to activate child for batch element instance, but no parent element instance found for key '%s'. The parent was likely terminated before processing this batch activation.";
    private final StateWriter stateWriter;
    private final TypedCommandWriter commandWriter;
    private final KeyGenerator keyGenerator;
    private final ElementInstanceState elementInstanceState;
    private final ProcessState processState;
    private final TypedRejectionWriter rejectionWriter;

    public ProcessInstanceBatchActivateProcessor(Writers writers, KeyGenerator keyGenerator, ElementInstanceState elementInstanceState, ProcessState processState) {
        this.commandWriter = writers.command();
        this.stateWriter = writers.state();
        this.keyGenerator = keyGenerator;
        this.elementInstanceState = elementInstanceState;
        this.processState = processState;
        this.rejectionWriter = writers.rejection();
    }

    @Override
    public void processRecord(TypedRecord<ProcessInstanceBatchRecord> record) {
        ProcessInstanceBatchRecord recordValue = (ProcessInstanceBatchRecord)record.getValue();
        long remainingChildrenToActivate = recordValue.getIndex();
        long batchElementInstanceKey = ((ProcessInstanceBatchRecord)record.getValue()).getBatchElementInstanceKey();
        ElementInstance parentElementInstance = this.elementInstanceState.getInstance(batchElementInstanceKey);
        if (parentElementInstance == null) {
            this.rejectionWriter.appendRejection(record, RejectionType.INVALID_STATE, PARENT_NOT_FOUND_ERROR_MESSAGE.formatted(batchElementInstanceKey));
            return;
        }
        if (remainingChildrenToActivate > 0L) {
            this.writeActivateChildCommand(parentElementInstance);
        }
        this.writeNextBatchCommand(remainingChildrenToActivate - 1L, record);
    }

    private void writeActivateChildCommand(ElementInstance parentElementInstance) {
        ProcessInstanceRecord childInstanceRecord = this.createChildInstanceRecord(parentElementInstance);
        this.commandWriter.appendFollowUpCommand(this.keyGenerator.nextKey(), (Intent)ProcessInstanceIntent.ACTIVATE_ELEMENT, (RecordValue)childInstanceRecord);
    }

    private void writeNextBatchCommand(long remainingChildrenToActivate, TypedRecord<ProcessInstanceBatchRecord> record) {
        ProcessInstanceBatchRecord recordValue = (ProcessInstanceBatchRecord)record.getValue();
        if (remainingChildrenToActivate > 0L) {
            this.writeFollowupBatchCommand(recordValue, remainingChildrenToActivate);
        } else {
            this.stateWriter.appendFollowUpEvent(record.getKey(), (Intent)ProcessInstanceBatchIntent.ACTIVATED, (RecordValue)recordValue);
        }
    }

    private void writeFollowupBatchCommand(ProcessInstanceBatchRecord recordValue, long remainingChildrenToActivate) {
        ProcessInstanceBatchRecord nextBatchRecord = new ProcessInstanceBatchRecord().setProcessInstanceKey(recordValue.getProcessInstanceKey()).setBatchElementInstanceKey(recordValue.getBatchElementInstanceKey()).setIndex(remainingChildrenToActivate);
        this.commandWriter.appendFollowUpCommand(this.keyGenerator.nextKey(), (Intent)ProcessInstanceBatchIntent.ACTIVATE, (RecordValue)nextBatchRecord);
    }

    private ProcessInstanceRecord createChildInstanceRecord(ElementInstance parentElementInstance) {
        ExecutableProcess processDefinition = this.processState.getProcessByKeyAndTenant(parentElementInstance.getValue().getProcessDefinitionKey(), parentElementInstance.getValue().getTenantId()).getProcess();
        AbstractFlowElement parentElement = processDefinition.getElementById(parentElementInstance.getValue().getElementId());
        ExecutableActivity childElement = ((ExecutableMultiInstanceBody)parentElement).getInnerActivity();
        ProcessInstanceRecord childInstanceRecord = new ProcessInstanceRecord();
        childInstanceRecord.wrap(parentElementInstance.getValue());
        childInstanceRecord.setFlowScopeKey(parentElementInstance.getKey()).setElementId(childElement.getId()).setBpmnElementType(childElement.getElementType()).setBpmnEventType(childElement.getEventType());
        return childInstanceRecord;
    }
}

