/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.transform;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.transform.DeploymentResourceTransformer;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.state.immutable.ResourceState;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentResource;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ResourceMetadataRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ResourceRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ResourceIntent;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import io.camunda.zeebe.util.Either;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.LongSupplier;
import org.agrona.DirectBuffer;

public class RpaTransformer
implements DeploymentResourceTransformer {
    private static final int INITIAL_VERSION = 1;
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    final Function<byte[], DirectBuffer> checksumGenerator;
    private final KeyGenerator keyGenerator;
    private final StateWriter stateWriter;
    private final ResourceState resourceState;

    public RpaTransformer(KeyGenerator keyGenerator, StateWriter stateWriter, Function<byte[], DirectBuffer> checksumGenerator, ResourceState resourceState) {
        this.keyGenerator = keyGenerator;
        this.stateWriter = stateWriter;
        this.checksumGenerator = checksumGenerator;
        this.resourceState = resourceState;
    }

    @Override
    public Either<Failure, Void> createMetadata(DeploymentResource deploymentResource, DeploymentRecord deployment) {
        return this.parseResource(deploymentResource).flatMap(resource -> this.checkForDuplicateResourceId(resource.id, deploymentResource, deployment).map(noDuplicates -> {
            ResourceMetadataRecord resourceMetadataRecord = (ResourceMetadataRecord)deployment.resourceMetadata().add();
            this.appendMetadataToResourceRecord(resourceMetadataRecord, (Resource)resource, deploymentResource, deployment);
            return null;
        }));
    }

    @Override
    public Either<Failure, Void> writeRecords(DeploymentResource resource, DeploymentRecord deployment) {
        if (deployment.hasDuplicatesOnly()) {
            return Either.right(null);
        }
        DirectBuffer checksum = this.checksumGenerator.apply(resource.getResource());
        deployment.resourceMetadata().stream().filter(metadata -> checksum.equals((Object)metadata.getChecksumBuffer())).findFirst().ifPresent(metadata -> {
            long key = metadata.getResourceKey();
            if (metadata.isDuplicate()) {
                key = this.keyGenerator.nextKey();
                metadata.setResourceKey(key).setVersion(this.resourceState.getNextResourceVersion(metadata.getResourceId(), metadata.getTenantId())).setDuplicate(false).setDeploymentKey(deployment.getDeploymentKey());
            }
            this.writeResourceRecord((ResourceMetadataRecord)metadata, resource);
        });
        return Either.right(null);
    }

    private void writeResourceRecord(ResourceMetadataRecord resourceMetadataRecord, DeploymentResource resource) {
        this.stateWriter.appendFollowUpEvent(resourceMetadataRecord.getResourceKey(), (Intent)ResourceIntent.CREATED, (RecordValue)new ResourceRecord().wrap(resourceMetadataRecord, resource.getResource()));
    }

    private void appendMetadataToResourceRecord(ResourceMetadataRecord resourceMetadataRecord, Resource resource, DeploymentResource deploymentResource, DeploymentRecord deploymentRecord) {
        LongSupplier newResourceKey = () -> ((KeyGenerator)this.keyGenerator).nextKey();
        DirectBuffer checksum = this.checksumGenerator.apply(deploymentResource.getResource());
        String tenantId = deploymentRecord.getTenantId();
        resourceMetadataRecord.setResourceId(resource.id);
        resourceMetadataRecord.setChecksum(checksum);
        resourceMetadataRecord.setResourceName(deploymentResource.getResourceName());
        resourceMetadataRecord.setTenantId(tenantId);
        Optional.ofNullable(resource.versionTag).ifPresent(arg_0 -> ((ResourceMetadataRecord)resourceMetadataRecord).setVersionTag(arg_0));
        this.resourceState.findLatestResourceById(resourceMetadataRecord.getResourceId(), tenantId).ifPresentOrElse(latestResource -> {
            boolean isDuplicate;
            boolean bl = isDuplicate = latestResource.getChecksum().equals((Object)resourceMetadataRecord.getChecksumBuffer()) && latestResource.getResourceName().equals((Object)resourceMetadataRecord.getResourceNameBuffer());
            if (isDuplicate) {
                int latestVersion = latestResource.getVersion();
                resourceMetadataRecord.setResourceKey(latestResource.getResourceKey()).setVersion(latestVersion).setDeploymentKey(latestResource.getDeploymentKey()).setDuplicate(true);
            } else {
                resourceMetadataRecord.setResourceKey(newResourceKey.getAsLong()).setVersion(this.resourceState.getNextResourceVersion(resource.id, tenantId)).setDeploymentKey(deploymentRecord.getDeploymentKey());
            }
        }, () -> resourceMetadataRecord.setResourceKey(newResourceKey.getAsLong()).setVersion(1).setDeploymentKey(deploymentRecord.getDeploymentKey()));
    }

    private Either<Failure, Resource> parseResource(DeploymentResource resource) {
        try {
            Resource res = (Resource)JSON_MAPPER.readValue(resource.getResource(), Resource.class);
            return this.validateResource(res);
        }
        catch (JsonProcessingException e) {
            String failureMessage = String.format("Failed to parse resource JSON. '%s': %s", resource.getResourceName(), e.getCause().getMessage());
            return Either.left((Object)new Failure(failureMessage));
        }
        catch (IOException e) {
            String failureMessage = String.format("'%s': %s", resource.getResourceName(), e.getCause().getMessage());
            return Either.left((Object)new Failure(failureMessage));
        }
    }

    private Either<Failure, Resource> validateResource(Resource res) {
        if (res.id == null) {
            return Either.left((Object)new Failure("Expected the resource id to be present, but none given"));
        }
        if (res.id.isBlank()) {
            return Either.left((Object)new Failure("Expected the resource id to be filled, but it is blank"));
        }
        return Either.right((Object)res);
    }

    private Either<Failure, ?> checkForDuplicateResourceId(String resourceId, DeploymentResource resource, DeploymentRecord record) {
        return record.getResourceMetadata().stream().filter(metadata -> metadata.getResourceId().equals(resourceId)).findFirst().map(dupeResource -> {
            String failureMessage = String.format("Expected the resource ids to be unique within a deployment but found a duplicated id '%s' in the resources '%s' and '%s'.", resourceId, dupeResource.getResourceName(), resource.getResourceName());
            return Either.left((Object)new Failure(failureMessage));
        }).orElse(Either.right(null));
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private record Resource(String id, String versionTag) {
    }
}

