/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.transform;

import io.camunda.zeebe.engine.EngineConfiguration;
import io.camunda.zeebe.engine.Loggers;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.transform.BpmnResourceTransformer;
import io.camunda.zeebe.engine.processing.deployment.transform.DeploymentResourceTransformer;
import io.camunda.zeebe.engine.processing.deployment.transform.DmnResourceTransformer;
import io.camunda.zeebe.engine.processing.deployment.transform.FormResourceTransformer;
import io.camunda.zeebe.engine.processing.deployment.transform.RpaTransformer;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentResource;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.FeatureFlags;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.InstantSource;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.agrona.DirectBuffer;
import org.slf4j.Logger;

public final class DeploymentTransformer {
    private static final Logger LOG = Loggers.PROCESS_PROCESSOR_LOGGER;
    private static final DeploymentResourceTransformer UNKNOWN_RESOURCE = new UnknownResourceTransformer();
    private final Map<String, DeploymentResourceTransformer> resourceTransformers;
    private final MessageDigest digestGenerator;
    private RejectionType rejectionType;
    private String rejectionReason;

    public DeploymentTransformer(StateWriter stateWriter, ProcessingState processingState, ExpressionProcessor expressionProcessor, KeyGenerator keyGenerator, FeatureFlags featureFlags, EngineConfiguration config, InstantSource clock) {
        try {
            this.digestGenerator = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        BpmnResourceTransformer bpmnResourceTransformer = new BpmnResourceTransformer(keyGenerator, stateWriter, this::getChecksum, processingState.getProcessState(), expressionProcessor, featureFlags.enableStraightThroughProcessingLoopDetector(), config, clock);
        DmnResourceTransformer dmnResourceTransformer = new DmnResourceTransformer(keyGenerator, stateWriter, this::getChecksum, processingState.getDecisionState());
        FormResourceTransformer formResourceTransformer = new FormResourceTransformer(keyGenerator, stateWriter, this::getChecksum, processingState.getFormState());
        RpaTransformer resourceTransformer = new RpaTransformer(keyGenerator, stateWriter, this::getChecksum, processingState.getResourceState());
        this.resourceTransformers = Map.ofEntries(Map.entry(".bpmn", bpmnResourceTransformer), Map.entry(".xml", bpmnResourceTransformer), Map.entry(".dmn", dmnResourceTransformer), Map.entry(".form", formResourceTransformer), Map.entry(".rpa", resourceTransformer));
    }

    public DirectBuffer getChecksum(byte[] resource) {
        return BufferUtil.wrapArray((byte[])this.digestGenerator.digest(resource));
    }

    public Either<Failure, Void> transform(DeploymentRecord deploymentEvent) {
        StringBuilder errors = new StringBuilder();
        boolean success = true;
        Iterator resourceIterator = deploymentEvent.resources().iterator();
        if (!resourceIterator.hasNext()) {
            this.rejectionType = RejectionType.INVALID_ARGUMENT;
            this.rejectionReason = "Expected to deploy at least one resource, but none given";
            return Either.left((Object)new Failure(this.rejectionReason));
        }
        while (resourceIterator.hasNext()) {
            DeploymentResource deploymentResource = (DeploymentResource)resourceIterator.next();
            success &= this.transformResource(deploymentEvent, errors, deploymentResource, transformer -> transformer::createMetadata);
        }
        if (success) {
            for (DeploymentResource deploymentResource : deploymentEvent.resources()) {
                success &= this.transformResource(deploymentEvent, errors, deploymentResource, transformer -> transformer::writeRecords);
            }
        }
        if (!success) {
            this.rejectionType = RejectionType.INVALID_ARGUMENT;
            this.rejectionReason = String.format("Expected to deploy new resources, but encountered the following errors:%s", errors);
            return Either.left((Object)new Failure(this.rejectionReason));
        }
        return Either.right(null);
    }

    private boolean transformResource(DeploymentRecord deploymentEvent, StringBuilder errors, DeploymentResource deploymentResource, Function<DeploymentResourceTransformer, BiFunction<DeploymentResource, DeploymentRecord, Either<Failure, Void>>> transformation) {
        String resourceName = deploymentResource.getResourceName();
        DeploymentResourceTransformer transformer = this.getResourceTransformer(resourceName);
        try {
            Either<Failure, Void> result = transformation.apply(transformer).apply(deploymentResource, deploymentEvent);
            if (result.isRight()) {
                return true;
            }
            String failureMessage = ((Failure)result.getLeft()).getMessage();
            errors.append("\n").append(failureMessage);
            return false;
        }
        catch (RuntimeException e) {
            LOG.error("Unexpected error while processing resource '{}'", (Object)resourceName, (Object)e);
            errors.append("\n'").append(resourceName).append("': ").append(e.getMessage());
            return false;
        }
    }

    public RejectionType getRejectionType() {
        return this.rejectionType;
    }

    public String getRejectionReason() {
        return this.rejectionReason;
    }

    private DeploymentResourceTransformer getResourceTransformer(String resourceName) {
        return this.resourceTransformers.entrySet().stream().filter(entry -> resourceName.endsWith((String)entry.getKey())).map(Map.Entry::getValue).findFirst().orElse(UNKNOWN_RESOURCE);
    }

    private static final class UnknownResourceTransformer
    implements DeploymentResourceTransformer {
        private UnknownResourceTransformer() {
        }

        @Override
        public Either<Failure, Void> createMetadata(DeploymentResource resource, DeploymentRecord deployment) {
            return this.createUnknownResourceTypeFailure(resource);
        }

        @Override
        public Either<Failure, Void> writeRecords(DeploymentResource resource, DeploymentRecord deployment) {
            return this.createUnknownResourceTypeFailure(resource);
        }

        private Either<Failure, Void> createUnknownResourceTypeFailure(DeploymentResource resource) {
            String failureMessage = String.format("%n'%s': unknown resource type", resource.getResourceName());
            return Either.left((Object)new Failure(failureMessage));
        }
    }
}

