/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.transformer.zeebe;

import io.camunda.zeebe.el.ExpressionLanguage;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowNode;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeExecutionListener;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Collection;
import java.util.function.Supplier;
import org.agrona.DirectBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecutionListenerTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionListenerTransformer.class);

    public void transform(ExecutableFlowNode executableFlowNode, Collection<ZeebeExecutionListener> executionListeners, ExpressionLanguage expressionLanguage) {
        executionListeners.forEach(listener -> {
            try {
                this.addListenerToFlowNode((ZeebeExecutionListener)listener, executableFlowNode, expressionLanguage);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to transform execution listener for flow node '{}', caught an unexpected exception: '{}': {}. Ignoring this listener definition.", new Object[]{BufferUtil.bufferAsString((DirectBuffer)executableFlowNode.getId()), e.getClass().getSimpleName(), e.getMessage()});
            }
        });
    }

    private void addListenerToFlowNode(ZeebeExecutionListener listener, ExecutableFlowNode flowNode, ExpressionLanguage expressionLanguage) {
        Either.right((Object)listener).flatMap(l -> this.requireNotNull((ZeebeExecutionListener)l, () -> l, "listener")).flatMap(l -> this.requireNotNull((ZeebeExecutionListener)l, () -> ((ZeebeExecutionListener)l).getEventType(), "eventType")).flatMap(l -> this.requireNotNull((ZeebeExecutionListener)l, () -> ((ZeebeExecutionListener)l).getType(), "type")).flatMap(l -> this.requireNotNull((ZeebeExecutionListener)l, () -> ((ZeebeExecutionListener)l).getRetries(), "retries")).ifRightOrLeft(ok -> flowNode.addListener(listener.getEventType(), expressionLanguage.parseExpression(listener.getType()), expressionLanguage.parseExpression(listener.getRetries())), error -> LOGGER.debug("Failed to transform execution listener for flow node '%s', because %s. Ignoring this listener definition.".formatted(BufferUtil.bufferAsString((DirectBuffer)flowNode.getId()), error.reason())));
    }

    private Either<Error, ZeebeExecutionListener> requireNotNull(ZeebeExecutionListener listener, Supplier<?> attributeSupplier, String attributeName) {
        if (attributeSupplier.get() == null) {
            return Either.left((Object)new Error("'%s' is null".formatted(attributeName)));
        }
        return Either.right((Object)listener);
    }

    private record Error(String reason) {
    }
}

