/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.common;

import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.common.EventTriggerBehavior;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEvent;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableStartEvent;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.deployment.DeployedProcess;
import io.camunda.zeebe.engine.state.immutable.EventScopeInstanceState;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageStartEventSubscriptionRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.impl.record.value.usertask.UserTaskRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.MessageStartEventSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class EventHandle {
    private static final DirectBuffer NO_VARIABLES = new UnsafeBuffer();
    private final ProcessInstanceRecord recordForPICreation = new ProcessInstanceRecord();
    private final MessageStartEventSubscriptionRecord startEventSubscriptionRecord = new MessageStartEventSubscriptionRecord();
    private final KeyGenerator keyGenerator;
    private final EventScopeInstanceState eventScopeInstanceState;
    private final ProcessState processState;
    private final TypedCommandWriter commandWriter;
    private final StateWriter stateWriter;
    private final EventTriggerBehavior eventTriggerBehavior;
    private final BpmnStateBehavior stateBehavior;

    public EventHandle(KeyGenerator keyGenerator, EventScopeInstanceState eventScopeInstanceState, Writers writers, ProcessState processState, EventTriggerBehavior eventTriggerBehavior, BpmnStateBehavior stateBehavior) {
        this.keyGenerator = keyGenerator;
        this.eventScopeInstanceState = eventScopeInstanceState;
        this.processState = processState;
        this.commandWriter = writers.command();
        this.stateWriter = writers.state();
        this.eventTriggerBehavior = eventTriggerBehavior;
        this.stateBehavior = stateBehavior;
    }

    public boolean canTriggerElement(ElementInstance eventScopeInstance, DirectBuffer elementId) {
        if (eventScopeInstance == null) {
            return false;
        }
        ElementInstance flowScopeInstance = this.stateBehavior.getElementInstance(eventScopeInstance.getParentKey());
        return eventScopeInstance.isActive() && this.eventScopeInstanceState.canTriggerEvent(eventScopeInstance.getKey(), elementId) && (flowScopeInstance == null || !flowScopeInstance.isInterrupted());
    }

    private long triggeringProcessEvent(long processDefinitionKey, long processInstanceKey, String tenantId, long eventScopeKey, DirectBuffer catchEventId, DirectBuffer variables) {
        return this.eventTriggerBehavior.triggeringProcessEvent(processDefinitionKey, processInstanceKey, tenantId, eventScopeKey, catchEventId, variables);
    }

    public void activateElement(ExecutableFlowElement catchEvent, long eventScopeKey, ProcessInstanceRecord elementRecord) {
        this.activateElement(catchEvent, eventScopeKey, elementRecord, NO_VARIABLES);
    }

    public void activateElement(ExecutableFlowElement catchEvent, long eventScopeKey, ProcessInstanceRecord elementRecord, DirectBuffer variables) {
        long processEventKey = this.triggeringProcessEvent(elementRecord.getProcessDefinitionKey(), elementRecord.getProcessInstanceKey(), elementRecord.getTenantId(), eventScopeKey, catchEvent.getId(), variables);
        if (this.isElementActivated(catchEvent)) {
            this.commandWriter.appendFollowUpCommand(eventScopeKey, (Intent)ProcessInstanceIntent.COMPLETE_ELEMENT, (RecordValue)elementRecord);
        } else if (catchEvent.getFlowScope().getElementType() == BpmnElementType.EVENT_SUB_PROCESS && catchEvent.getElementType() == BpmnElementType.START_EVENT) {
            ExecutableStartEvent startEvent = (ExecutableStartEvent)catchEvent;
            this.eventTriggerBehavior.triggerEventSubProcess(startEvent, eventScopeKey, elementRecord, variables);
        } else if (this.isInterrupting(catchEvent)) {
            this.commandWriter.appendFollowUpCommand(eventScopeKey, (Intent)ProcessInstanceIntent.TERMINATE_ELEMENT, (RecordValue)elementRecord);
        } else {
            this.eventTriggerBehavior.activateTriggeredEvent(processEventKey, catchEvent, eventScopeKey, elementRecord.getFlowScopeKey(), elementRecord, variables);
        }
    }

    public void triggeringProcessEvent(JobRecord jobRecord) {
        this.triggeringProcessEvent(jobRecord.getProcessDefinitionKey(), jobRecord.getProcessInstanceKey(), jobRecord.getTenantId(), jobRecord.getElementInstanceKey(), jobRecord.getElementIdBuffer(), jobRecord.getVariablesBuffer());
    }

    public void triggeringProcessEvent(UserTaskRecord userTaskRecord) {
        this.triggeringProcessEvent(userTaskRecord.getProcessDefinitionKey(), userTaskRecord.getProcessInstanceKey(), userTaskRecord.getTenantId(), userTaskRecord.getElementInstanceKey(), userTaskRecord.getElementIdBuffer(), userTaskRecord.getVariablesBuffer());
    }

    private boolean isElementActivated(ExecutableFlowElement catchEvent) {
        return catchEvent.getElementType() == BpmnElementType.INTERMEDIATE_CATCH_EVENT || catchEvent.getElementType() == BpmnElementType.RECEIVE_TASK || catchEvent.getElementType() == BpmnElementType.EVENT_BASED_GATEWAY;
    }

    private boolean isInterrupting(ExecutableFlowElement catchEvent) {
        if (catchEvent instanceof ExecutableCatchEvent) {
            ExecutableCatchEvent event = (ExecutableCatchEvent)catchEvent;
            return event.isInterrupting();
        }
        return false;
    }

    public long triggerMessageStartEvent(long subscriptionKey, MessageStartEventSubscriptionRecord subscription, long messageKey, DirectBuffer messageName, DirectBuffer correlationKey, DirectBuffer variables) {
        long newProcessInstanceKey = this.keyGenerator.nextKey();
        this.startEventSubscriptionRecord.setProcessDefinitionKey(subscription.getProcessDefinitionKey()).setBpmnProcessId(subscription.getBpmnProcessIdBuffer()).setStartEventId(subscription.getStartEventIdBuffer()).setProcessInstanceKey(newProcessInstanceKey).setCorrelationKey(correlationKey).setMessageKey(messageKey).setMessageName(messageName).setVariables(variables).setTenantId(subscription.getTenantId());
        this.stateWriter.appendFollowUpEvent(subscriptionKey, (Intent)MessageStartEventSubscriptionIntent.CORRELATED, (RecordValue)this.startEventSubscriptionRecord);
        this.activateProcessInstanceForStartEvent(subscription.getProcessDefinitionKey(), newProcessInstanceKey, this.startEventSubscriptionRecord.getStartEventIdBuffer(), variables, subscription.getTenantId());
        return newProcessInstanceKey;
    }

    public void activateProcessInstanceForStartEvent(long processDefinitionKey, long processInstanceKey, DirectBuffer targetElementId, DirectBuffer variablesBuffer, String tenantId) {
        this.triggeringProcessEvent(processDefinitionKey, processInstanceKey, tenantId, processDefinitionKey, targetElementId, variablesBuffer);
        DeployedProcess process = this.processState.getProcessByKeyAndTenant(processDefinitionKey, tenantId);
        this.recordForPICreation.setBpmnProcessId(process.getBpmnProcessId()).setProcessDefinitionKey(process.getKey()).setVersion(process.getVersion()).setProcessInstanceKey(processInstanceKey).setElementId(process.getProcess().getId()).setBpmnElementType(process.getProcess().getElementType()).setTenantId(tenantId);
        this.commandWriter.appendFollowUpCommand(processInstanceKey, (Intent)ProcessInstanceIntent.ACTIVATE_ELEMENT, (RecordValue)this.recordForPICreation);
    }
}

