/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.container;

import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContainerProcessor;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnCompensationSubscriptionBehaviour;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnEventSubscriptionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnJobBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnVariableMappingBehavior;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableAdHocSubProcess;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElement;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.instance.EventTrigger;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.util.Either;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class AdHocSubProcessProcessor
implements BpmnElementContainerProcessor<ExecutableAdHocSubProcess> {
    private final BpmnStateBehavior stateBehavior;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnVariableMappingBehavior variableMappingBehavior;
    private final BpmnEventSubscriptionBehavior eventSubscriptionBehavior;
    private final BpmnJobBehavior jobBehavior;
    private final BpmnIncidentBehavior incidentBehavior;
    private final ExpressionProcessor expressionProcessor;
    private final BpmnCompensationSubscriptionBehaviour compensationSubscriptionBehaviour;

    public AdHocSubProcessProcessor(BpmnBehaviors bpmnBehaviors, BpmnStateTransitionBehavior stateTransitionBehavior) {
        this.stateBehavior = bpmnBehaviors.stateBehavior();
        this.variableMappingBehavior = bpmnBehaviors.variableMappingBehavior();
        this.eventSubscriptionBehavior = bpmnBehaviors.eventSubscriptionBehavior();
        this.jobBehavior = bpmnBehaviors.jobBehavior();
        this.incidentBehavior = bpmnBehaviors.incidentBehavior();
        this.expressionProcessor = bpmnBehaviors.expressionBehavior();
        this.compensationSubscriptionBehaviour = bpmnBehaviors.compensationSubscriptionBehaviour();
        this.stateTransitionBehavior = stateTransitionBehavior;
    }

    @Override
    public Class<ExecutableAdHocSubProcess> getType() {
        return ExecutableAdHocSubProcess.class;
    }

    @Override
    public Either<Failure, ?> onActivate(ExecutableAdHocSubProcess element, BpmnElementContext context) {
        return this.variableMappingBehavior.applyInputMappings(context, element);
    }

    @Override
    public Either<Failure, ?> finalizeActivation(ExecutableAdHocSubProcess element, BpmnElementContext context) {
        return this.readActivateElementsCollection(element, context).flatMap(elementsToActivate -> this.eventSubscriptionBehavior.subscribeToEvents(element, context).map(ok -> elementsToActivate)).thenDo(elementsToActivate -> {
            BpmnElementContext activated = this.stateTransitionBehavior.transitionToActivated(context, element.getEventType());
            this.activateElements(element, activated, (List<String>)elementsToActivate);
        });
    }

    @Override
    public Either<Failure, ?> onComplete(ExecutableAdHocSubProcess element, BpmnElementContext context) {
        return this.variableMappingBehavior.applyOutputMappings(context, element).thenDo(ok -> this.eventSubscriptionBehavior.unsubscribeFromEvents(context));
    }

    @Override
    public Either<Failure, ?> finalizeCompletion(ExecutableAdHocSubProcess element, BpmnElementContext context) {
        this.compensationSubscriptionBehaviour.createCompensationSubscription(element, context);
        return this.stateTransitionBehavior.transitionToCompleted(element, context).thenDo(completed -> {
            this.compensationSubscriptionBehaviour.completeCompensationHandler((BpmnElementContext)completed);
            this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, (BpmnElementContext)completed);
        });
    }

    @Override
    public void onTerminate(ExecutableAdHocSubProcess element, BpmnElementContext terminating) {
        if (element.hasExecutionListeners()) {
            this.jobBehavior.cancelJob(terminating);
        }
        this.eventSubscriptionBehavior.unsubscribeFromEvents(terminating);
        this.incidentBehavior.resolveIncidents(terminating);
        this.compensationSubscriptionBehaviour.deleteSubscriptionsOfSubprocess(terminating);
        boolean noActiveChildInstances = this.stateTransitionBehavior.terminateChildInstances(terminating);
        if (noActiveChildInstances) {
            this.terminate(element, terminating);
        }
    }

    private void terminate(ExecutableAdHocSubProcess element, BpmnElementContext context) {
        ElementInstance flowScopeInstance = this.stateBehavior.getFlowScopeInstance(context);
        this.eventSubscriptionBehavior.findEventTrigger(context).filter(eventTrigger -> flowScopeInstance.isActive() && !flowScopeInstance.isInterrupted()).ifPresentOrElse(eventTrigger -> {
            BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(context, element.getEventType());
            this.eventSubscriptionBehavior.activateTriggeredEvent(terminated.getElementInstanceKey(), terminated.getFlowScopeKey(), (EventTrigger)((Object)eventTrigger), terminated);
        }, () -> {
            BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(context, element.getEventType());
            this.stateTransitionBehavior.onElementTerminated(element, terminated);
        });
    }

    private Either<Failure, List<String>> readActivateElementsCollection(ExecutableAdHocSubProcess adHocSubProcess, BpmnElementContext context) {
        Expression activeElementsCollection = adHocSubProcess.getActiveElementsCollection();
        if (activeElementsCollection == null) {
            return Either.right(Collections.emptyList());
        }
        return this.expressionProcessor.evaluateArrayOfStringsExpression(activeElementsCollection, context.getElementInstanceKey()).mapLeft(failure -> new Failure("Failed to activate ad-hoc elements. " + failure.getMessage(), ErrorType.EXTRACT_VALUE_ERROR)).flatMap(elements -> AdHocSubProcessProcessor.validateActiveElements(adHocSubProcess, elements));
    }

    private static Either<Failure, List<String>> validateActiveElements(ExecutableAdHocSubProcess adHocSubProcess, List<String> activateElementsCollection) {
        List<String> elementsNotFound = activateElementsCollection.stream().filter(elementId -> !adHocSubProcess.getAdHocActivitiesById().containsKey(elementId)).toList();
        if (elementsNotFound.isEmpty()) {
            return Either.right(activateElementsCollection);
        }
        String elementIds = elementsNotFound.stream().map(arg_0 -> AdHocSubProcessProcessor.lambda$validateActiveElements$11("'%s'", arg_0)).collect(Collectors.joining(", "));
        return Either.left((Object)new Failure("Failed to activate ad-hoc elements. No BPMN elements found with ids: %s.".formatted(elementIds), ErrorType.EXTRACT_VALUE_ERROR));
    }

    private void activateElements(ExecutableAdHocSubProcess element, BpmnElementContext context, List<String> elementsToActivate) {
        elementsToActivate.stream().map(element.getAdHocActivitiesById()::get).forEach(elementToActivate -> this.stateTransitionBehavior.activateChildInstance(context, (ExecutableFlowElement)elementToActivate));
    }

    @Override
    public void afterExecutionPathCompleted(ExecutableAdHocSubProcess element, BpmnElementContext adHocSubProcessContext, BpmnElementContext childContext, Boolean satisfiesCompletionCondition) {
        if (this.stateBehavior.canBeCompleted(childContext)) {
            this.stateTransitionBehavior.completeElement(adHocSubProcessContext);
        }
    }

    @Override
    public void onChildTerminated(ExecutableAdHocSubProcess element, BpmnElementContext adHocSubProcessContext, BpmnElementContext childContext) {
        if (this.stateBehavior.canBeTerminated(childContext)) {
            this.terminate(element, adHocSubProcessContext);
        }
    }

    private static /* synthetic */ String lambda$validateActiveElements$11(String rec$, Object xva$0) {
        return "'%s'".formatted(xva$0);
    }
}

