/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.behavior;

import io.camunda.zeebe.msgpack.spec.MsgPackWriter;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Map;
import java.util.stream.Collectors;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.slf4j.Logger;

public final class HeaderEncoder {
    private static final int INITIAL_SIZE_KEY_VALUE_PAIR = 128;
    private final Logger logger;
    private final MsgPackWriter msgPackWriter = new MsgPackWriter();

    public HeaderEncoder(Logger logger) {
        this.logger = logger;
    }

    public DirectBuffer encode(Map<String, String> taskHeaders) {
        if (taskHeaders == null || taskHeaders.isEmpty()) {
            return JobRecord.NO_HEADERS;
        }
        UnsafeBuffer buffer = new UnsafeBuffer(0L, 0);
        Map<String, String> validHeaders = taskHeaders.entrySet().stream().filter(entry -> this.isValidHeader((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (validHeaders.size() != taskHeaders.size()) {
            this.logger.debug("Ignored {} invalid headers.", (Object)(taskHeaders.size() - validHeaders.size()));
        }
        ExpandableArrayBuffer expandableBuffer = new ExpandableArrayBuffer(128 * validHeaders.size());
        this.msgPackWriter.wrap((MutableDirectBuffer)expandableBuffer, 0);
        this.msgPackWriter.writeMapHeader(validHeaders.size());
        validHeaders.forEach((k, v) -> {
            DirectBuffer key = BufferUtil.wrapString((String)k);
            this.msgPackWriter.writeString(key);
            DirectBuffer value = BufferUtil.wrapString((String)v);
            this.msgPackWriter.writeString(value);
        });
        buffer.wrap(expandableBuffer.byteArray(), 0, this.msgPackWriter.getOffset());
        return buffer;
    }

    private boolean isValidHeader(String key, String value) {
        return key != null && !key.isEmpty() && value != null && !value.isEmpty();
    }
}

