/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.appliers;

import io.camunda.zeebe.engine.state.TypedEventApplier;
import io.camunda.zeebe.engine.state.immutable.UserTaskState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.state.mutable.MutableUserTaskState;
import io.camunda.zeebe.protocol.impl.record.value.usertask.UserTaskRecord;
import io.camunda.zeebe.protocol.record.intent.UserTaskIntent;

public final class UserTaskAssignedApplier
implements TypedEventApplier<UserTaskIntent, UserTaskRecord> {
    private final MutableUserTaskState userTaskState;

    public UserTaskAssignedApplier(MutableProcessingState processingState) {
        this.userTaskState = processingState.getUserTaskState();
    }

    @Override
    public void applyState(long key, UserTaskRecord value) {
        String assignee = value.getAssignee();
        UserTaskRecord userTask = this.userTaskState.getUserTask(key);
        userTask.setAssignee(assignee);
        this.userTaskState.update(userTask);
        this.userTaskState.updateUserTaskLifecycleState(key, UserTaskState.LifecycleState.CREATED);
    }
}

