/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state;

import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.engine.state.deployment.DbDeploymentState;
import io.camunda.zeebe.engine.state.distribution.DbDistributionState;
import io.camunda.zeebe.engine.state.immutable.DeploymentState;
import io.camunda.zeebe.engine.state.immutable.DistributionState;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.engine.state.immutable.MessageState;
import io.camunda.zeebe.engine.state.immutable.PendingMessageSubscriptionState;
import io.camunda.zeebe.engine.state.immutable.PendingProcessMessageSubscriptionState;
import io.camunda.zeebe.engine.state.immutable.ScheduledTaskState;
import io.camunda.zeebe.engine.state.immutable.TimerInstanceState;
import io.camunda.zeebe.engine.state.immutable.UserTaskState;
import io.camunda.zeebe.engine.state.instance.DbJobState;
import io.camunda.zeebe.engine.state.instance.DbTimerInstanceState;
import io.camunda.zeebe.engine.state.instance.DbUserTaskState;
import io.camunda.zeebe.engine.state.message.DbMessageState;
import io.camunda.zeebe.engine.state.message.DbMessageSubscriptionState;
import io.camunda.zeebe.engine.state.message.DbProcessMessageSubscriptionState;
import io.camunda.zeebe.engine.state.message.TransientPendingSubscriptionState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import java.time.InstantSource;

public final class ScheduledTaskDbState
implements ScheduledTaskState {
    private final DistributionState distributionState;
    private final MessageState messageState;
    private final TimerInstanceState timerInstanceState;
    private final JobState jobState;
    private final DeploymentState deploymentState;
    private final PendingMessageSubscriptionState pendingMessageSubscriptionState;
    private final PendingProcessMessageSubscriptionState pendingProcessMessageSubscriptionState;
    private final UserTaskState userTaskState;

    public ScheduledTaskDbState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext, int partitionId, TransientPendingSubscriptionState transientMessageSubscriptionState, TransientPendingSubscriptionState transientProcessMessageSubscriptionState, InstantSource clock) {
        this.distributionState = new DbDistributionState(zeebeDb, transactionContext);
        this.messageState = new DbMessageState(zeebeDb, transactionContext, partitionId);
        this.timerInstanceState = new DbTimerInstanceState(zeebeDb, transactionContext);
        this.jobState = new DbJobState(zeebeDb, transactionContext);
        this.deploymentState = new DbDeploymentState(zeebeDb, transactionContext);
        this.pendingMessageSubscriptionState = new DbMessageSubscriptionState(zeebeDb, transactionContext, transientMessageSubscriptionState, clock);
        this.pendingProcessMessageSubscriptionState = new DbProcessMessageSubscriptionState(zeebeDb, transactionContext, transientProcessMessageSubscriptionState, clock);
        this.userTaskState = new DbUserTaskState(zeebeDb, transactionContext);
    }

    @Override
    public DistributionState getDistributionState() {
        return this.distributionState;
    }

    @Override
    public MessageState getMessageState() {
        return this.messageState;
    }

    @Override
    public TimerInstanceState getTimerState() {
        return this.timerInstanceState;
    }

    @Override
    public JobState getJobState() {
        return this.jobState;
    }

    @Override
    public DeploymentState getDeploymentState() {
        return this.deploymentState;
    }

    @Override
    public PendingMessageSubscriptionState getPendingMessageSubscriptionState() {
        return this.pendingMessageSubscriptionState;
    }

    @Override
    public PendingProcessMessageSubscriptionState getPendingProcessMessageSubscriptionState() {
        return this.pendingProcessMessageSubscriptionState;
    }

    @Override
    public UserTaskState getUserTaskState() {
        return this.userTaskState;
    }
}

