/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.common;

import io.camunda.zeebe.dmn.DecisionContext;
import io.camunda.zeebe.dmn.DecisionEngine;
import io.camunda.zeebe.dmn.DecisionEvaluationResult;
import io.camunda.zeebe.dmn.EvaluatedDecision;
import io.camunda.zeebe.dmn.EvaluatedInput;
import io.camunda.zeebe.dmn.EvaluatedOutput;
import io.camunda.zeebe.dmn.MatchedRule;
import io.camunda.zeebe.dmn.ParsedDecisionRequirementsGraph;
import io.camunda.zeebe.dmn.impl.VariablesContext;
import io.camunda.zeebe.engine.metrics.ProcessEngineMetrics;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.state.deployment.DeployedDrg;
import io.camunda.zeebe.engine.state.deployment.PersistedDecision;
import io.camunda.zeebe.engine.state.immutable.DecisionState;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.value.decision.DecisionEvaluationRecord;
import io.camunda.zeebe.protocol.impl.record.value.decision.EvaluatedDecisionRecord;
import io.camunda.zeebe.protocol.impl.record.value.decision.EvaluatedInputRecord;
import io.camunda.zeebe.protocol.impl.record.value.decision.EvaluatedOutputRecord;
import io.camunda.zeebe.protocol.impl.record.value.decision.MatchedRuleRecord;
import io.camunda.zeebe.protocol.record.intent.DecisionEvaluationIntent;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.camunda.zeebe.util.collection.Tuple;
import java.util.Map;
import java.util.stream.Collectors;
import org.agrona.DirectBuffer;

public class DecisionBehavior {
    private static final DecisionInfo UNKNOWN_DECISION_INFO = new DecisionInfo(-1L, -1);
    private final DecisionEngine decisionEngine;
    private final DecisionState decisionState;
    private final ProcessEngineMetrics metrics;

    public DecisionBehavior(DecisionEngine decisionEngine, ProcessingState processingState, ProcessEngineMetrics metrics) {
        this.decisionState = processingState.getDecisionState();
        this.decisionEngine = decisionEngine;
        this.metrics = metrics;
    }

    public Either<Failure, PersistedDecision> findLatestDecisionByIdAndTenant(String decisionId, String tenantId) {
        return Either.ofOptional(this.decisionState.findLatestDecisionByIdAndTenant(BufferUtil.wrapString((String)decisionId), tenantId)).orElse((Object)new Failure("no decision found for id '%s'".formatted(decisionId))).mapLeft(failure -> this.formatDecisionLookupFailure((Failure)failure, decisionId));
    }

    public Either<Failure, PersistedDecision> findDecisionByIdAndDeploymentKeyAndTenant(String decisionId, long deploymentKey, String tenantId) {
        return Either.ofOptional(this.decisionState.findDecisionByIdAndDeploymentKey(tenantId, BufferUtil.wrapString((String)decisionId), deploymentKey)).orElse((Object)new Failure("Expected to evaluate decision '%s' with binding type 'deployment', but no such decision found in the deployment with key %s which contained the current process. To resolve this incident, migrate the process instance to a process definition that is deployed together with the intended decision to evaluate.".formatted(decisionId, deploymentKey)));
    }

    public Either<Failure, PersistedDecision> findDecisionByIdAndVersionTagAndTenant(String decisionId, String versionTag, String tenantId) {
        return Either.ofOptional(this.decisionState.findDecisionByIdAndVersionTag(tenantId, BufferUtil.wrapString((String)decisionId), versionTag)).orElse((Object)new Failure("Expected to evaluate decision with id '%s' and version tag '%s', but no such decision found. To resolve this incident, deploy a decision with the given id and version tag.".formatted(decisionId, versionTag)));
    }

    public Either<Failure, PersistedDecision> findDecisionByKeyAndTenant(long decisionKey, String tenantId) {
        return Either.ofOptional(this.decisionState.findDecisionByTenantAndKey(tenantId, decisionKey)).orElse((Object)new Failure("no decision found for key '%s'".formatted(decisionKey))).mapLeft(failure -> this.formatDecisionLookupFailure((Failure)failure, decisionKey));
    }

    public Either<Failure, ParsedDecisionRequirementsGraph> findParsedDrgByDecision(PersistedDecision persistedDecision) {
        return this.findDrgByDecision(persistedDecision).map(DeployedDrg::getParsedDecisionRequirements).mapLeft(failure -> this.formatDecisionLookupFailure((Failure)failure, BufferUtil.bufferAsString((DirectBuffer)persistedDecision.getDecisionId())));
    }

    public Failure formatDecisionLookupFailure(Failure failure, long decisionKey) {
        return this.formatDecisionLookupFailure(failure, String.valueOf(decisionKey));
    }

    public Failure formatDecisionLookupFailure(Failure failure, String decisionId) {
        return new Failure("Expected to evaluate decision '%s', but %s".formatted(decisionId, failure.getMessage()));
    }

    public DecisionEvaluationResult evaluateDecisionInDrg(ParsedDecisionRequirementsGraph drg, String decisionId, DirectBuffer variables) {
        VariablesContext evaluationContext = new VariablesContext(MsgPackConverter.convertToMap((DirectBuffer)variables));
        DecisionEvaluationResult evaluationResult = this.decisionEngine.evaluateDecisionById(drg, decisionId, (DecisionContext)evaluationContext);
        this.updateDecisionMetrics(evaluationResult);
        return evaluationResult;
    }

    public Tuple<DecisionEvaluationIntent, DecisionEvaluationRecord> createDecisionEvaluationEvent(PersistedDecision decision, DecisionEvaluationResult decisionResult) {
        DecisionEvaluationIntent decisionEvaluationIntent;
        DecisionEvaluationRecord decisionEvaluationEvent = new DecisionEvaluationRecord().setDecisionKey(decision.getDecisionKey()).setDecisionId(decision.getDecisionId()).setDecisionName(decision.getDecisionName()).setDecisionVersion(decision.getVersion()).setDecisionRequirementsKey(decision.getDecisionRequirementsKey()).setDecisionRequirementsId(decision.getDecisionRequirementsId()).setTenantId(decision.getTenantId());
        Map<String, DecisionInfo> decisionKeysByDecisionId = this.decisionState.findDecisionsByTenantAndDecisionRequirementsKey(decision.getTenantId(), decision.getDecisionRequirementsKey()).stream().collect(Collectors.toMap(persistedDecision -> BufferUtil.bufferAsString((DirectBuffer)persistedDecision.getDecisionId()), DecisionInfo::new));
        decisionResult.getEvaluatedDecisions().forEach(evaluatedDecision -> this.addDecisionToEvaluationEvent((EvaluatedDecision)evaluatedDecision, decisionKeysByDecisionId.getOrDefault(evaluatedDecision.decisionId(), UNKNOWN_DECISION_INFO), decisionEvaluationEvent));
        if (decisionResult.isFailure()) {
            decisionEvaluationIntent = DecisionEvaluationIntent.FAILED;
            decisionEvaluationEvent.setEvaluationFailureMessage(decisionResult.getFailureMessage()).setFailedDecisionId(decisionResult.getFailedDecisionId());
        } else {
            decisionEvaluationIntent = DecisionEvaluationIntent.EVALUATED;
            decisionEvaluationEvent.setDecisionOutput(decisionResult.getOutput());
        }
        return new Tuple((Object)decisionEvaluationIntent, (Object)decisionEvaluationEvent);
    }

    private void updateDecisionMetrics(DecisionEvaluationResult evaluationResult) {
        if (evaluationResult.isFailure()) {
            this.metrics.increaseFailedEvaluatedDmnElements(evaluationResult.getEvaluatedDecisions().size());
        } else {
            this.metrics.increaseSuccessfullyEvaluatedDmnElements(evaluationResult.getEvaluatedDecisions().size());
        }
    }

    private Either<Failure, DeployedDrg> findDrgByDecision(PersistedDecision decision) {
        long key = decision.getDecisionRequirementsKey();
        DirectBuffer id = decision.getDecisionRequirementsId();
        return Either.ofOptional(this.decisionState.findDecisionRequirementsByTenantAndKey(decision.getTenantId(), key)).orElse((Object)new Failure("no drg found for id '%s'".formatted(BufferUtil.bufferAsString((DirectBuffer)id))));
    }

    private void addDecisionToEvaluationEvent(EvaluatedDecision evaluatedDecision, DecisionInfo decisionInfo, DecisionEvaluationRecord decisionEvaluationEvent) {
        EvaluatedDecisionRecord evaluatedDecisionRecord = (EvaluatedDecisionRecord)decisionEvaluationEvent.evaluatedDecisions().add();
        evaluatedDecisionRecord.setDecisionId(evaluatedDecision.decisionId()).setDecisionName(evaluatedDecision.decisionName()).setDecisionKey(decisionInfo.key()).setDecisionVersion(decisionInfo.version()).setDecisionType(evaluatedDecision.decisionType().name()).setDecisionOutput(evaluatedDecision.decisionOutput()).setTenantId(decisionEvaluationEvent.getTenantId());
        evaluatedDecision.evaluatedInputs().forEach(evaluatedInput -> this.addInputToEvaluationEvent((EvaluatedInput)evaluatedInput, evaluatedDecisionRecord));
        evaluatedDecision.matchedRules().forEach(matchedRule -> this.addMatchedRuleToEvaluationEvent((MatchedRule)matchedRule, evaluatedDecisionRecord));
    }

    private void addMatchedRuleToEvaluationEvent(MatchedRule matchedRule, EvaluatedDecisionRecord evaluatedDecisionRecord) {
        MatchedRuleRecord matchedRuleRecord = (MatchedRuleRecord)evaluatedDecisionRecord.matchedRules().add();
        matchedRuleRecord.setRuleId(matchedRule.ruleId()).setRuleIndex(matchedRule.ruleIndex());
        matchedRule.evaluatedOutputs().forEach(evaluatedOutput -> this.addOutputToEvaluationEvent((EvaluatedOutput)evaluatedOutput, matchedRuleRecord));
    }

    private void addInputToEvaluationEvent(EvaluatedInput evaluatedInput, EvaluatedDecisionRecord evaluatedDecisionRecord) {
        EvaluatedInputRecord inputRecord = ((EvaluatedInputRecord)evaluatedDecisionRecord.evaluatedInputs().add()).setInputId(evaluatedInput.inputId()).setInputValue(evaluatedInput.inputValue());
        if (evaluatedInput.inputName() != null) {
            inputRecord.setInputName(evaluatedInput.inputName());
        }
    }

    private void addOutputToEvaluationEvent(EvaluatedOutput evaluatedOutput, MatchedRuleRecord matchedRuleRecord) {
        EvaluatedOutputRecord outputRecord = ((EvaluatedOutputRecord)matchedRuleRecord.evaluatedOutputs().add()).setOutputId(evaluatedOutput.outputId()).setOutputValue(evaluatedOutput.outputValue());
        if (evaluatedOutput.outputName() != null) {
            outputRecord.setOutputName(evaluatedOutput.outputName());
        }
    }

    private record DecisionInfo(long key, int version) {
        DecisionInfo(PersistedDecision persistedDecision) {
            this(persistedDecision.getDecisionKey(), persistedDecision.getVersion());
        }
    }
}

