/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.routing;

import io.camunda.zeebe.engine.state.immutable.RoutingState;
import io.camunda.zeebe.protocol.impl.SubscriptionUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.agrona.DirectBuffer;

public interface RoutingInfo {
    public Set<Integer> partitions();

    public int partitionForCorrelationKey(DirectBuffer var1);

    public static RoutingInfo forStaticPartitions(int partitionCount) {
        Set<Integer> partitions = IntStream.rangeClosed(1, partitionCount).boxed().collect(Collectors.toSet());
        return new StaticRoutingInfo(partitions, partitionCount);
    }

    public static RoutingInfo dynamic(RoutingState routingState, RoutingInfo fallback) {
        return new DynamicRoutingInfo(routingState, fallback);
    }

    public static class StaticRoutingInfo
    implements RoutingInfo {
        private final Set<Integer> otherPartitions;
        private final int partitionCount;

        public StaticRoutingInfo(Set<Integer> otherPartitions, int partitionCount) {
            this.otherPartitions = otherPartitions;
            this.partitionCount = partitionCount;
        }

        @Override
        public Set<Integer> partitions() {
            return this.otherPartitions;
        }

        @Override
        public int partitionForCorrelationKey(DirectBuffer correlationKey) {
            return SubscriptionUtil.getSubscriptionPartitionId((DirectBuffer)correlationKey, (int)this.partitionCount);
        }
    }

    public static class DynamicRoutingInfo
    implements RoutingInfo {
        private final RoutingState routingState;
        private final RoutingInfo fallback;

        public DynamicRoutingInfo(RoutingState routingState, RoutingInfo fallback) {
            this.routingState = routingState;
            this.fallback = fallback;
        }

        @Override
        public Set<Integer> partitions() {
            if (!this.routingState.isInitialized()) {
                return this.fallback.partitions();
            }
            return this.routingState.partitions();
        }

        @Override
        public int partitionForCorrelationKey(DirectBuffer correlationKey) {
            int partitionCount;
            if (!this.routingState.isInitialized()) {
                return this.fallback.partitionForCorrelationKey(correlationKey);
            }
            RoutingState.MessageCorrelation messageCorrelation = this.routingState.messageCorrelation();
            Objects.requireNonNull(messageCorrelation);
            RoutingState.MessageCorrelation messageCorrelation2 = messageCorrelation;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RoutingState.MessageCorrelation.HashMod.class}, (Object)messageCorrelation2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: 
            }
            RoutingState.MessageCorrelation.HashMod hashMod = (RoutingState.MessageCorrelation.HashMod)messageCorrelation2;
            try {
                int n2;
                partitionCount = n2 = hashMod.partitionCount();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            return SubscriptionUtil.getSubscriptionPartitionId((DirectBuffer)correlationKey, (int)partitionCount);
        }
    }
}

