/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration.to_8_3.legacy;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.engine.Loggers;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.engine.state.instance.JobRecordValue;
import io.camunda.zeebe.engine.state.instance.JobStateValue;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.util.EnsureUtil;
import org.agrona.DirectBuffer;
import org.slf4j.Logger;

public class LegacyJobState {
    private static final Logger LOG = Loggers.PROCESS_PROCESSOR_LOGGER;
    private final JobRecordValue jobRecordToRead = new JobRecordValue();
    private final JobRecordValue jobRecordToWrite = new JobRecordValue();
    private final DbLong jobKey;
    private final DbForeignKey<DbLong> fkJob;
    private final ColumnFamily<DbLong, JobRecordValue> jobsColumnFamily;
    private final JobStateValue jobState = new JobStateValue();
    private final ColumnFamily<DbForeignKey<DbLong>, JobStateValue> statesJobColumnFamily;
    private final DbString jobTypeKey;
    private final DbCompositeKey<DbString, DbForeignKey<DbLong>> typeJobKey;
    private final ColumnFamily<DbCompositeKey<DbString, DbForeignKey<DbLong>>, DbNil> activatableColumnFamily;

    public LegacyJobState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.jobKey = new DbLong();
        this.fkJob = new DbForeignKey((DbKey)this.jobKey, (Enum)ZbColumnFamilies.JOBS);
        this.jobsColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.JOBS, transactionContext, (DbKey)this.jobKey, (DbValue)this.jobRecordToRead);
        this.statesJobColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.JOB_STATES, transactionContext, this.fkJob, (DbValue)this.jobState);
        this.jobTypeKey = new DbString();
        this.typeJobKey = new DbCompositeKey((DbKey)this.jobTypeKey, this.fkJob);
        this.activatableColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DEPRECATED_JOB_ACTIVATABLE, transactionContext, this.typeJobKey, (DbValue)DbNil.INSTANCE);
    }

    public void create(long key, JobRecord record) {
        DirectBuffer type = record.getTypeBuffer();
        this.createJob(key, record, type);
    }

    private void createJob(long key, JobRecord record, DirectBuffer type) {
        this.createJobRecord(key, record);
        this.initializeJobState();
        this.makeJobActivatable(type, key);
    }

    private void createJobRecord(long key, JobRecord record) {
        this.jobKey.wrapLong(key);
        this.jobRecordToWrite.setRecordWithoutVariables(record);
        this.jobsColumnFamily.insert((DbKey)this.jobKey, (DbValue)this.jobRecordToWrite);
    }

    private void makeJobActivatable(DirectBuffer type, long key) {
        EnsureUtil.ensureNotNullOrEmpty((String)"type", (DirectBuffer)type);
        this.jobTypeKey.wrapBuffer(type);
        this.jobKey.wrapLong(key);
        this.activatableColumnFamily.upsert(this.typeJobKey, (DbValue)DbNil.INSTANCE);
    }

    private void initializeJobState() {
        this.jobState.setState(JobState.State.ACTIVATABLE);
        this.statesJobColumnFamily.insert(this.fkJob, (DbValue)this.jobState);
    }

    public ColumnFamily<DbCompositeKey<DbString, DbForeignKey<DbLong>>, DbNil> getActivatableColumnFamily() {
        return this.activatableColumnFamily;
    }
}

