/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration.to_8_3;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.db.impl.DbTenantAwareKey;
import io.camunda.zeebe.engine.state.message.MessageStartEventSubscription;
import io.camunda.zeebe.engine.state.migration.MemoryBoundedColumnIteration;
import io.camunda.zeebe.engine.state.migration.to_8_3.legacy.LegacyMessageStartEventSubscriptionState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;

public class DbMessageStartEventSubscriptionMigrationState {
    private final LegacyMessageStartEventSubscriptionState from;
    private final DbMessageStartEventSubscriptionState to;

    public DbMessageStartEventSubscriptionMigrationState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.from = new LegacyMessageStartEventSubscriptionState(zeebeDb, transactionContext);
        this.to = new DbMessageStartEventSubscriptionState(zeebeDb, transactionContext);
    }

    public void migrateMessageStartEventSubscriptionForMultiTenancy() {
        MemoryBoundedColumnIteration iterator = new MemoryBoundedColumnIteration();
        this.to.tenantIdKey.wrapString("<default>");
        iterator.drain(this.from.getSubscriptionsColumnFamily(), (key, value) -> {
            value.getRecord().setTenantId("<default>");
            this.to.messageName.wrapBuffer(((DbString)key.first()).getBuffer());
            this.to.processDefinitionKey.wrapLong(((DbLong)key.second()).getValue());
            this.to.subscriptionsColumnFamily.insert(this.to.messageNameAndProcessDefinitionKey, (DbValue)value);
        });
        iterator.drain(this.from.getSubscriptionsOfProcessDefinitionKeyColumnFamily(), (key, value) -> {
            this.to.processDefinitionKey.wrapLong(((DbLong)key.first()).getValue());
            this.to.messageName.wrapBuffer(((DbString)key.second()).getBuffer());
            this.to.subscriptionsOfProcessDefinitionKeyColumnFamily.insert(this.to.processDefinitionKeyAndMessageName, (DbValue)DbNil.INSTANCE);
        });
    }

    private static final class DbMessageStartEventSubscriptionState {
        private final DbString tenantIdKey;
        private final DbString messageName;
        private final DbTenantAwareKey<DbString> tenantAwareMessageName;
        private final DbLong processDefinitionKey;
        private final DbCompositeKey<DbTenantAwareKey<DbString>, DbLong> messageNameAndProcessDefinitionKey;
        private final ColumnFamily<DbCompositeKey<DbTenantAwareKey<DbString>, DbLong>, MessageStartEventSubscription> subscriptionsColumnFamily;
        private final MessageStartEventSubscription messageStartEventSubscription = new MessageStartEventSubscription();
        private final DbCompositeKey<DbLong, DbTenantAwareKey<DbString>> processDefinitionKeyAndMessageName;
        private final ColumnFamily<DbCompositeKey<DbLong, DbTenantAwareKey<DbString>>, DbNil> subscriptionsOfProcessDefinitionKeyColumnFamily;

        public DbMessageStartEventSubscriptionState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
            this.tenantIdKey = new DbString();
            this.messageName = new DbString();
            this.tenantAwareMessageName = new DbTenantAwareKey(this.tenantIdKey, (DbKey)this.messageName, DbTenantAwareKey.PlacementType.PREFIX);
            this.processDefinitionKey = new DbLong();
            this.messageNameAndProcessDefinitionKey = new DbCompositeKey(this.tenantAwareMessageName, (DbKey)this.processDefinitionKey);
            this.subscriptionsColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGE_START_EVENT_SUBSCRIPTION_BY_NAME_AND_KEY, transactionContext, this.messageNameAndProcessDefinitionKey, (DbValue)this.messageStartEventSubscription);
            this.processDefinitionKeyAndMessageName = new DbCompositeKey((DbKey)this.processDefinitionKey, this.tenantAwareMessageName);
            this.subscriptionsOfProcessDefinitionKeyColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGE_START_EVENT_SUBSCRIPTION_BY_KEY_AND_NAME, transactionContext, this.processDefinitionKeyAndMessageName, (DbValue)DbNil.INSTANCE);
        }
    }
}

