/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.appliers;

import io.camunda.zeebe.engine.state.TypedEventApplier;
import io.camunda.zeebe.engine.state.mutable.MutableDecisionState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessState;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DecisionRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DecisionRequirementsMetadataRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DecisionRequirementsRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.value.deployment.DecisionRequirementsMetadataValue;
import io.camunda.zeebe.protocol.record.value.deployment.DeploymentResource;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.function.Predicate;
import org.agrona.DirectBuffer;

public class DeploymentDistributedApplier
implements TypedEventApplier<DeploymentIntent, DeploymentRecord> {
    private final MutableProcessState mutableProcessState;
    private final MutableDecisionState decisionState;

    public DeploymentDistributedApplier(MutableProcessState mutableProcessState, MutableDecisionState decisionState) {
        this.mutableProcessState = mutableProcessState;
        this.decisionState = decisionState;
    }

    @Override
    public void applyState(long key, DeploymentRecord value) {
        this.mutableProcessState.putDeployment(value);
        this.putDmnResourcesInState(value);
    }

    private void putDmnResourcesInState(DeploymentRecord value) {
        value.decisionRequirementsMetadata().stream().filter(Predicate.not(DecisionRequirementsMetadataRecord::isDuplicate)).forEach(drg -> {
            DirectBuffer resource = this.getResourceByName(value, drg.getResourceName());
            DecisionRequirementsRecord decisionRequirementsRecord = this.createDecisionRequirementsRecord((DecisionRequirementsMetadataValue)drg, resource);
            this.decisionState.storeDecisionRequirements(decisionRequirementsRecord);
        });
        value.decisionsMetadata().stream().filter(Predicate.not(DecisionRecord::isDuplicate)).forEach(this.decisionState::storeDecisionRecord);
    }

    private DirectBuffer getResourceByName(DeploymentRecord deployment, String resourceName) {
        return (DirectBuffer)deployment.getResources().stream().filter(resource -> resource.getResourceName().equals(resourceName)).map(DeploymentResource::getResource).map(BufferUtil::wrapArray).findFirst().orElseThrow(() -> new NoSuchResourceException(resourceName));
    }

    private DecisionRequirementsRecord createDecisionRequirementsRecord(DecisionRequirementsMetadataValue drg, DirectBuffer resource) {
        return new DecisionRequirementsRecord().setDecisionRequirementsKey(drg.getDecisionRequirementsKey()).setDecisionRequirementsId(drg.getDecisionRequirementsId()).setDecisionRequirementsVersion(drg.getDecisionRequirementsVersion()).setDecisionRequirementsName(drg.getDecisionRequirementsName()).setNamespace(drg.getNamespace()).setResourceName(drg.getResourceName()).setChecksum((DirectBuffer)BufferUtil.wrapArray((byte[])drg.getChecksum())).setResource(resource).setTenantId(drg.getTenantId());
    }

    private static final class NoSuchResourceException
    extends IllegalStateException {
        private NoSuchResourceException(String resourceName) {
            super(String.format("Expected to find resource '%s' in deployment but not found", resourceName));
        }
    }
}

