/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.appliers;

import io.camunda.zeebe.engine.state.TypedEventApplier;
import io.camunda.zeebe.engine.state.mutable.MutableAuthorizationState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.protocol.impl.record.value.authorization.AuthorizationRecord;
import io.camunda.zeebe.protocol.record.intent.AuthorizationIntent;
import io.camunda.zeebe.protocol.record.value.AuthorizationResourceType;
import java.util.List;

public final class AuthorizationPermissionAddedApplier
implements TypedEventApplier<AuthorizationIntent, AuthorizationRecord> {
    private final MutableAuthorizationState authorizationState;

    public AuthorizationPermissionAddedApplier(MutableProcessingState state) {
        this.authorizationState = state.getAuthorizationState();
    }

    @Override
    public void applyState(long key, AuthorizationRecord value) {
        Long ownerKey = value.getOwnerKey();
        AuthorizationResourceType resourceType = value.getResourceType();
        List permissions = value.getPermissions();
        permissions.forEach(permission -> this.authorizationState.createOrAddPermission(ownerKey, resourceType, permission.getPermissionType(), permission.getResourceIds()));
    }
}

