/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.message;

import io.camunda.zeebe.engine.processing.distribution.CommandDistributionBehavior;
import io.camunda.zeebe.engine.processing.streamprocessor.DistributedTypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.immutable.MessageSubscriptionState;
import io.camunda.zeebe.engine.state.message.MessageSubscription;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageSubscriptionRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.util.buffer.BufferWriter;

public class MessageSubscriptionMigrateProcessor
implements DistributedTypedRecordProcessor<MessageSubscriptionRecord> {
    private final MessageSubscriptionState subscriptionState;
    private final StateWriter stateWriter;
    private final TypedRejectionWriter rejectionWriter;
    private final CommandDistributionBehavior commandDistributionBehavior;
    private final MessageSubscriptionRecord messageSubscriptionRecord = new MessageSubscriptionRecord();

    public MessageSubscriptionMigrateProcessor(MessageSubscriptionState subscriptionState, Writers writers, CommandDistributionBehavior commandDistributionBehavior) {
        this.subscriptionState = subscriptionState;
        this.stateWriter = writers.state();
        this.rejectionWriter = writers.rejection();
        this.commandDistributionBehavior = commandDistributionBehavior;
    }

    @Override
    public void processNewCommand(TypedRecord<MessageSubscriptionRecord> command) {
        this.migrateMessageSubscription(command);
    }

    @Override
    public void processDistributedCommand(TypedRecord<MessageSubscriptionRecord> command) {
        this.migrateMessageSubscription(command);
        this.commandDistributionBehavior.acknowledgeCommand(command);
    }

    private void migrateMessageSubscription(TypedRecord<MessageSubscriptionRecord> command) {
        MessageSubscriptionRecord value = (MessageSubscriptionRecord)command.getValue();
        MessageSubscription subscription = this.subscriptionState.get(value.getElementInstanceKey(), value.getMessageNameBuffer());
        if (subscription == null) {
            this.rejectionWriter.appendRejection(command, RejectionType.NOT_FOUND, "Expected to migrate a message subscription with key '%s', but subscription not found for element instance key '%d' and the provided message name".formatted(command.getKey(), value.getElementInstanceKey()));
            return;
        }
        this.messageSubscriptionRecord.reset();
        this.messageSubscriptionRecord.copyFrom((BufferWriter)subscription.getRecord());
        this.stateWriter.appendFollowUpEvent(subscription.getKey(), (Intent)MessageSubscriptionIntent.MIGRATED, (RecordValue)this.messageSubscriptionRecord.setBpmnProcessId(value.getBpmnProcessIdBuffer()).setInterrupting(value.isInterrupting()));
    }
}

