/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.message;

import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.common.EventHandle;
import io.camunda.zeebe.engine.processing.message.MessageCorrelateBehavior;
import io.camunda.zeebe.engine.processing.message.Subscriptions;
import io.camunda.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.immutable.EventScopeInstanceState;
import io.camunda.zeebe.engine.state.immutable.MessageStartEventSubscriptionState;
import io.camunda.zeebe.engine.state.immutable.MessageState;
import io.camunda.zeebe.engine.state.immutable.MessageSubscriptionState;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageCorrelationRecord;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.MessageCorrelationIntent;
import io.camunda.zeebe.protocol.record.intent.MessageIntent;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.stream.api.state.KeyGenerator;

public final class MessageCorrelationCorrelateProcessor
implements TypedRecordProcessor<MessageCorrelationRecord> {
    private static final String SUBSCRIPTION_NOT_FOUND = "Expected to find subscription for message with name '%s' and correlation key '%s', but none was found.";
    private final MessageCorrelateBehavior correlateBehavior;
    private final KeyGenerator keyGenerator;
    private final StateWriter stateWriter;
    private final TypedResponseWriter responseWriter;
    private final TypedRejectionWriter rejectionWriter;

    public MessageCorrelationCorrelateProcessor(Writers writers, KeyGenerator keyGenerator, EventScopeInstanceState eventScopeInstanceState, ProcessState processState, BpmnBehaviors bpmnBehaviors, MessageStartEventSubscriptionState startEventSubscriptionState, MessageState messageState, MessageSubscriptionState messageSubscriptionState, SubscriptionCommandSender commandSender) {
        this.stateWriter = writers.state();
        this.responseWriter = writers.response();
        this.rejectionWriter = writers.rejection();
        this.keyGenerator = keyGenerator;
        EventHandle eventHandle = new EventHandle(keyGenerator, eventScopeInstanceState, writers, processState, bpmnBehaviors.eventTriggerBehavior(), bpmnBehaviors.stateBehavior());
        this.correlateBehavior = new MessageCorrelateBehavior(startEventSubscriptionState, messageState, eventHandle, this.stateWriter, messageSubscriptionState, commandSender);
    }

    @Override
    public void processRecord(TypedRecord<MessageCorrelationRecord> command) {
        MessageCorrelationRecord messageCorrelationRecord = (MessageCorrelationRecord)command.getValue();
        long messageKey = this.keyGenerator.nextKey();
        messageCorrelationRecord.setMessageKey(messageKey).setRequestId(command.getRequestId()).setRequestStreamId(command.getRequestStreamId());
        MessageRecord messageRecord = new MessageRecord().setName(((MessageCorrelationRecord)command.getValue()).getName()).setCorrelationKey(((MessageCorrelationRecord)command.getValue()).getCorrelationKey()).setVariables(((MessageCorrelationRecord)command.getValue()).getVariablesBuffer()).setTenantId(((MessageCorrelationRecord)command.getValue()).getTenantId()).setTimeToLive(-1L);
        this.stateWriter.appendFollowUpEvent(messageKey, (Intent)MessageIntent.PUBLISHED, (RecordValue)messageRecord);
        this.stateWriter.appendFollowUpEvent(messageKey, (Intent)MessageCorrelationIntent.CORRELATING, (RecordValue)messageCorrelationRecord);
        Subscriptions correlatingSubscriptions = new Subscriptions();
        MessageCorrelateBehavior.MessageData messageData = this.createMessageData(messageKey, messageCorrelationRecord);
        this.correlateBehavior.correlateToMessageEvents(messageData, correlatingSubscriptions);
        this.correlateBehavior.correlateToMessageStartEvents(messageData, correlatingSubscriptions);
        if (correlatingSubscriptions.isEmpty()) {
            String errorMessage = SUBSCRIPTION_NOT_FOUND.formatted(((MessageCorrelationRecord)command.getValue()).getName(), ((MessageCorrelationRecord)command.getValue()).getCorrelationKey());
            this.rejectionWriter.appendRejection(command, RejectionType.NOT_FOUND, errorMessage);
            this.responseWriter.writeRejectionOnCommand(command, RejectionType.NOT_FOUND, errorMessage);
        } else {
            correlatingSubscriptions.getFirstMessageStartEventSubscription().ifPresent(subscription -> {
                messageCorrelationRecord.setProcessInstanceKey(subscription.getProcessInstanceKey());
                this.stateWriter.appendFollowUpEvent(messageKey, (Intent)MessageCorrelationIntent.CORRELATED, (RecordValue)messageCorrelationRecord);
                this.responseWriter.writeEventOnCommand(messageKey, (Intent)MessageCorrelationIntent.CORRELATED, (UnpackedObject)messageCorrelationRecord, command);
            });
        }
        this.correlateBehavior.sendCorrelateCommands(messageData, correlatingSubscriptions);
        this.stateWriter.appendFollowUpEvent(messageKey, (Intent)MessageIntent.EXPIRED, (RecordValue)messageRecord);
    }

    private MessageCorrelateBehavior.MessageData createMessageData(long messageKey, MessageCorrelationRecord messageCorrelationRecord) {
        return new MessageCorrelateBehavior.MessageData(messageKey, messageCorrelationRecord.getNameBuffer(), messageCorrelationRecord.getCorrelationKeyBuffer(), messageCorrelationRecord.getVariablesBuffer(), messageCorrelationRecord.getTenantId());
    }
}

