/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.message;

import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageBatchRecord;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.MessageIntent;
import io.camunda.zeebe.stream.api.records.ExceededBatchRecordSizeException;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessageBatchExpireProcessor
implements TypedRecordProcessor<MessageBatchRecord> {
    private static final Logger LOG = LoggerFactory.getLogger(MessageBatchExpireProcessor.class);
    private final StateWriter stateWriter;
    private final MessageRecord emptyDeleteMessageCommand = new MessageRecord().setName("").setCorrelationKey("").setTimeToLive(-1L);

    public MessageBatchExpireProcessor(StateWriter stateWriter) {
        this.stateWriter = stateWriter;
    }

    @Override
    public void processRecord(TypedRecord<MessageBatchRecord> record) {
        int expiredMessagesCount = 0;
        int totalMessagesCount = ((MessageBatchRecord)record.getValue()).getMessageKeys().size();
        Iterator iterator = ((MessageBatchRecord)record.getValue()).getMessageKeys().iterator();
        while (iterator.hasNext()) {
            long messageKey = (Long)iterator.next();
            try {
                this.stateWriter.appendFollowUpEvent(messageKey, (Intent)MessageIntent.EXPIRED, (RecordValue)this.emptyDeleteMessageCommand);
                ++expiredMessagesCount;
            }
            catch (ExceededBatchRecordSizeException exceededBatchRecordSizeException) {
                LOG.warn("Expected to expire messages in a batch, but exceeded the resulting batch size after expiring {} out of {} messages. Try using a lower Message TTL Checker's batch limit.", (Object)expiredMessagesCount, (Object)totalMessagesCount);
                break;
            }
        }
    }
}

