/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.processing.job.behaviour.JobUpdateBehaviour;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.stream.api.records.TypedRecord;

public class JobUpdateTimeoutProcessor
implements TypedRecordProcessor<JobRecord> {
    private final JobUpdateBehaviour jobUpdateBehaviour;
    private final TypedRejectionWriter rejectionWriter;
    private final TypedResponseWriter responseWriter;
    private final StateWriter stateWriter;

    public JobUpdateTimeoutProcessor(JobUpdateBehaviour jobUpdateBehaviour, Writers writers) {
        this.jobUpdateBehaviour = jobUpdateBehaviour;
        this.rejectionWriter = writers.rejection();
        this.responseWriter = writers.response();
        this.stateWriter = writers.state();
    }

    @Override
    public void processRecord(TypedRecord<JobRecord> command) {
        long jobKey = command.getKey();
        this.jobUpdateBehaviour.getJob(jobKey, command).ifRightOrLeft(job -> this.jobUpdateBehaviour.updateJobTimeout(jobKey, ((JobRecord)command.getValue()).getTimeout(), (JobRecord)job).ifPresentOrElse(errorMessage -> {
            this.rejectionWriter.appendRejection((TypedRecord<? extends RecordValue>)command, RejectionType.INVALID_STATE, (String)errorMessage);
            this.responseWriter.writeRejectionOnCommand(command, RejectionType.INVALID_STATE, (String)errorMessage);
        }, () -> {
            this.stateWriter.appendFollowUpEvent(jobKey, (Intent)JobIntent.TIMEOUT_UPDATED, (RecordValue)job);
            this.responseWriter.writeEventOnCommand(jobKey, (Intent)JobIntent.TIMEOUT_UPDATED, (UnpackedObject)job, command);
        }), errorMessage -> this.responseWriter.writeRejectionOnCommand(command, RejectionType.NOT_FOUND, (String)errorMessage));
    }
}

