/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.transformer;

import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableJobWorkerElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.ModelElementTransformer;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.TransformContext;
import io.camunda.zeebe.engine.processing.deployment.model.transformer.zeebe.TaskDefinitionTransformer;
import io.camunda.zeebe.engine.processing.deployment.model.transformer.zeebe.TaskHeadersTransformer;
import io.camunda.zeebe.model.bpmn.instance.FlowElement;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeTaskDefinition;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeTaskHeaders;

public final class JobWorkerElementTransformer<T extends FlowElement>
implements ModelElementTransformer<T> {
    private final Class<T> type;
    private final TaskDefinitionTransformer taskDefinitionTransformer = new TaskDefinitionTransformer();
    private final TaskHeadersTransformer taskHeadersTransformer = new TaskHeadersTransformer();

    public JobWorkerElementTransformer(Class<T> type) {
        this.type = type;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public void transform(T element, TransformContext context) {
        ExecutableProcess process = context.getCurrentProcess();
        ExecutableJobWorkerElement jobWorkerElement = process.getElementById(element.getId(), ExecutableJobWorkerElement.class);
        ZeebeTaskDefinition taskDefinition = (ZeebeTaskDefinition)element.getSingleExtensionElement(ZeebeTaskDefinition.class);
        this.taskDefinitionTransformer.transform(jobWorkerElement, context, taskDefinition);
        ZeebeTaskHeaders taskHeaders = (ZeebeTaskHeaders)element.getSingleExtensionElement(ZeebeTaskHeaders.class);
        this.taskHeadersTransformer.transform(jobWorkerElement, taskHeaders, (FlowElement)element);
    }
}

