/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.transformer;

import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEvent;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableEventBasedGateway;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.ModelElementTransformer;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.TransformContext;
import io.camunda.zeebe.model.bpmn.instance.EventBasedGateway;
import java.util.List;
import java.util.stream.Collectors;

public final class EventBasedGatewayTransformer
implements ModelElementTransformer<EventBasedGateway> {
    @Override
    public Class<EventBasedGateway> getType() {
        return EventBasedGateway.class;
    }

    @Override
    public void transform(EventBasedGateway element, TransformContext context) {
        ExecutableProcess process = context.getCurrentProcess();
        ExecutableEventBasedGateway gateway = process.getElementById(element.getId(), ExecutableEventBasedGateway.class);
        List<ExecutableCatchEvent> connectedEvents = this.getConnectedCatchEvents(gateway);
        gateway.setEvents(connectedEvents);
    }

    private List<ExecutableCatchEvent> getConnectedCatchEvents(ExecutableEventBasedGateway gateway) {
        return gateway.getOutgoing().stream().map(e -> (ExecutableCatchEvent)((Object)e.getTarget())).collect(Collectors.toList());
    }
}

