/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.task;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementProcessor;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.task.JobWorkerTaskProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableJobWorkerTask;
import io.camunda.zeebe.util.Either;

public abstract class JobWorkerTaskSupportingProcessor<T extends ExecutableJobWorkerTask>
implements BpmnElementProcessor<T> {
    private final JobWorkerTaskProcessor delegate;

    public JobWorkerTaskSupportingProcessor(BpmnBehaviors bpmnBehaviors, BpmnStateTransitionBehavior stateTransitionBehavior) {
        this.delegate = new JobWorkerTaskProcessor(bpmnBehaviors, stateTransitionBehavior);
    }

    @Override
    public Either<Failure, ?> onActivate(T element, BpmnElementContext context) {
        return this.isJobBehavior(element, context) ? this.delegate.onActivate((ExecutableJobWorkerTask)element, context) : this.onActivateInternal(element, context);
    }

    @Override
    public Either<Failure, ?> finalizeActivation(T element, BpmnElementContext context) {
        return this.isJobBehavior(element, context) ? this.delegate.finalizeActivation((ExecutableJobWorkerTask)element, context) : this.onFinalizeActivationInternal(element, context);
    }

    @Override
    public Either<Failure, ?> onComplete(T element, BpmnElementContext context) {
        return this.isJobBehavior(element, context) ? this.delegate.onComplete((ExecutableJobWorkerTask)element, context) : this.onCompleteInternal(element, context);
    }

    @Override
    public Either<Failure, ?> finalizeCompletion(T element, BpmnElementContext context) {
        return this.isJobBehavior(element, context) ? this.delegate.finalizeCompletion((ExecutableJobWorkerTask)element, context) : this.onFinalizeCompletionInternal(element, context);
    }

    @Override
    public void onTerminate(T element, BpmnElementContext context) {
        if (this.isJobBehavior(element, context)) {
            this.delegate.onTerminate((ExecutableJobWorkerTask)element, context);
        } else {
            this.onTerminateInternal(element, context);
        }
    }

    protected abstract boolean isJobBehavior(T var1, BpmnElementContext var2);

    protected abstract Either<Failure, ?> onActivateInternal(T var1, BpmnElementContext var2);

    protected Either<Failure, ?> onFinalizeActivationInternal(T element, BpmnElementContext context) {
        return SUCCESS;
    }

    protected abstract Either<Failure, ?> onCompleteInternal(T var1, BpmnElementContext var2);

    protected Either<Failure, ?> onFinalizeCompletionInternal(T element, BpmnElementContext context) {
        return SUCCESS;
    }

    protected abstract void onTerminateInternal(T var1, BpmnElementContext var2);
}

