/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.behavior;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.common.ElementTreePathBuilder;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.immutable.IncidentState;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import io.camunda.zeebe.util.collection.Tuple;

public final class BpmnIncidentBehavior {
    private final IncidentRecord incidentRecord = new IncidentRecord();
    private final IncidentState incidentState;
    private final StateWriter stateWriter;
    private final KeyGenerator keyGenerator;
    private final ElementInstanceState elementInstanceState;
    private final ProcessState processState;

    public BpmnIncidentBehavior(ProcessingState processingState, KeyGenerator keyGenerator, StateWriter stateWriter) {
        this.incidentState = processingState.getIncidentState();
        this.elementInstanceState = processingState.getElementInstanceState();
        this.processState = processingState.getProcessState();
        this.keyGenerator = keyGenerator;
        this.stateWriter = stateWriter;
    }

    public void resolveJobIncident(long jobKey) {
        boolean hasIncident;
        long incidentKey = this.incidentState.getJobIncidentKey(jobKey);
        boolean bl = hasIncident = incidentKey != -1L;
        if (hasIncident) {
            IncidentRecord incidentRecord = this.incidentState.getIncidentRecord(incidentKey);
            this.stateWriter.appendFollowUpEvent(incidentKey, (Intent)IncidentIntent.RESOLVED, (RecordValue)incidentRecord);
        }
    }

    public void createIncident(Tuple<Failure, BpmnElementContext> failureAndContext) {
        this.createIncident((Failure)failureAndContext.getLeft(), (BpmnElementContext)failureAndContext.getRight());
    }

    public void createIncident(Failure failure, BpmnElementContext context) {
        long variableScopeKey = failure.getVariableScopeKey() > 0L ? failure.getVariableScopeKey() : context.getElementInstanceKey();
        ElementTreePathBuilder.ElementTreePathProperties treePathProperties = new ElementTreePathBuilder().withElementInstanceState(this.elementInstanceState).withProcessState(this.processState).withElementInstanceKey(context.getElementInstanceKey()).build();
        this.incidentRecord.reset();
        this.incidentRecord.setProcessInstanceKey(context.getProcessInstanceKey()).setBpmnProcessId(context.getBpmnProcessId()).setProcessDefinitionKey(context.getProcessDefinitionKey()).setElementInstanceKey(context.getElementInstanceKey()).setElementId(context.getElementId()).setVariableScopeKey(variableScopeKey).setErrorType(failure.getErrorType()).setErrorMessage(failure.getMessage()).setTenantId(context.getTenantId()).setElementInstancePath(treePathProperties.elementInstancePath()).setProcessDefinitionPath(treePathProperties.processDefinitionPath()).setCallingElementPath(treePathProperties.callingElementPath());
        long key = this.keyGenerator.nextKey();
        this.stateWriter.appendFollowUpEvent(key, (Intent)IncidentIntent.CREATED, (RecordValue)this.incidentRecord);
    }

    public void resolveIncidents(BpmnElementContext context) {
        this.resolveIncidents(context.getElementInstanceKey());
    }

    public void resolveIncidents(long elementInstanceKey) {
        this.incidentState.forExistingProcessIncident(elementInstanceKey, (record, key) -> this.stateWriter.appendFollowUpEvent(key, (Intent)IncidentIntent.RESOLVED, (RecordValue)record));
    }
}

