/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.variable;

import io.camunda.zeebe.engine.state.variable.DocumentEntry;
import io.camunda.zeebe.msgpack.spec.MsgPackReader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.collections.Int2IntHashMap;
import org.agrona.concurrent.UnsafeBuffer;

final class DocumentEntryIterator
implements Iterator<DocumentEntry> {
    private final MsgPackReader reader;
    private final DocumentEntry entry = new DocumentEntry();
    private final DirectBuffer document = new UnsafeBuffer();
    private Int2IntHashMap.EntryIterator offsetIterator;
    private int documentLength;

    DocumentEntryIterator() {
        this(new MsgPackReader());
    }

    DocumentEntryIterator(MsgPackReader reader) {
        this.reader = reader;
    }

    @Override
    public boolean hasNext() {
        return this.offsetIterator.hasNext();
    }

    @Override
    public DocumentEntry next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.offsetIterator.next();
        int keyOffset = this.offsetIterator.getIntKey();
        int valueOffset = this.offsetIterator.getIntValue();
        this.reader.wrap(this.document, keyOffset, this.documentLength - keyOffset);
        int nameLength = this.reader.readStringLength();
        int nameOffset = keyOffset + this.reader.getOffset();
        this.reader.wrap(this.document, valueOffset, this.documentLength - valueOffset);
        this.reader.skipValue();
        int valueLength = this.reader.getOffset();
        this.entry.wrap(this.document, nameOffset, nameLength, valueOffset, valueLength);
        return this.entry;
    }

    @Override
    public void remove() {
        this.offsetIterator.remove();
    }

    void wrap(DirectBuffer document, Int2IntHashMap.EntryIterator offsetIterator) {
        this.document.wrap(document);
        this.offsetIterator = offsetIterator;
        this.documentLength = document.capacity();
    }
}

