/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.timer;

import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.state.immutable.TimerInstanceState;
import io.camunda.zeebe.engine.state.instance.TimerInstance;
import io.camunda.zeebe.protocol.impl.record.value.timer.TimerRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.stream.api.records.TypedRecord;

public final class TimerCancelProcessor
implements TypedRecordProcessor<TimerRecord> {
    public static final String NO_TIMER_FOUND_MESSAGE = "Expected to cancel timer with key '%d', but no such timer was found";
    private final TimerInstanceState timerInstanceState;
    private final StateWriter stateWriter;
    private final TypedRejectionWriter rejectionWriter;

    public TimerCancelProcessor(TimerInstanceState timerInstanceState, StateWriter stateWriter, TypedRejectionWriter rejectionWriter) {
        this.timerInstanceState = timerInstanceState;
        this.stateWriter = stateWriter;
        this.rejectionWriter = rejectionWriter;
    }

    @Override
    public void processRecord(TypedRecord<TimerRecord> record) {
        TimerRecord timer = (TimerRecord)record.getValue();
        TimerInstance timerInstance = this.timerInstanceState.get(timer.getElementInstanceKey(), record.getKey());
        if (timerInstance == null) {
            this.rejectionWriter.appendRejection(record, RejectionType.NOT_FOUND, String.format(NO_TIMER_FOUND_MESSAGE, record.getKey()));
        } else {
            this.stateWriter.appendFollowUpEvent(record.getKey(), (Intent)TimerIntent.CANCELED, (RecordValue)timer);
        }
    }
}

