/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.transformer;

import io.camunda.zeebe.el.EvaluationResult;
import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.el.ExpressionLanguage;
import io.camunda.zeebe.el.ResultType;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableMessage;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.ModelElementTransformer;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.TransformContext;
import io.camunda.zeebe.model.bpmn.instance.ExtensionElements;
import io.camunda.zeebe.model.bpmn.instance.Message;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeSubscription;
import java.util.Optional;

public final class MessageTransformer
implements ModelElementTransformer<Message> {
    @Override
    public Class<Message> getType() {
        return Message.class;
    }

    @Override
    public void transform(Message element, TransformContext context) {
        Optional subscription;
        String id = element.getId();
        ExpressionLanguage expressionLanguage = context.getExpressionLanguage();
        ExecutableMessage executableElement = new ExecutableMessage(id);
        ExtensionElements extensionElements = element.getExtensionElements();
        if (extensionElements != null && (subscription = extensionElements.getElementsQuery().filterByType(ZeebeSubscription.class).findSingleResult()).isPresent()) {
            Expression correlationKeyExpression = expressionLanguage.parseExpression(((ZeebeSubscription)subscription.get()).getCorrelationKey());
            executableElement.setCorrelationKeyExpression(correlationKeyExpression);
        }
        if (element.getName() != null) {
            EvaluationResult messageNameResult;
            Expression messageNameExpression = expressionLanguage.parseExpression(element.getName());
            executableElement.setMessageNameExpression(messageNameExpression);
            if (messageNameExpression.isStatic() && (messageNameResult = expressionLanguage.evaluateExpression(messageNameExpression, variable -> null)).getType() == ResultType.STRING) {
                String messageName = messageNameResult.getString();
                executableElement.setMessageName(messageName);
            }
            context.addMessage(executableElement);
        }
    }
}

