/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.deployment;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.BinaryProperty;
import io.camunda.zeebe.msgpack.property.BooleanProperty;
import io.camunda.zeebe.msgpack.property.IntegerProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.ResourceMetadataValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public class ResourceMetadataRecord
extends UnifiedRecordValue
implements ResourceMetadataValue {
    private final StringProperty resourceIdProp = new StringProperty("resourceId");
    private final IntegerProperty versionProp = new IntegerProperty("version");
    private final LongProperty resourceKeyProp = new LongProperty("resourceKey");
    private final BinaryProperty checksumProp = new BinaryProperty("checksum");
    private final StringProperty resourceNameProp = new StringProperty("resourceName");
    private final BooleanProperty isDuplicateProp = new BooleanProperty("isDuplicate", false);
    private final StringProperty tenantIdProp = new StringProperty("tenantId", "<default>");
    private final LongProperty deploymentKeyProp = new LongProperty("deploymentKey", -1L);
    private final StringProperty versionTagProp = new StringProperty("versionTag", "");

    public ResourceMetadataRecord() {
        super(9);
        this.declareProperty((BaseProperty)this.resourceIdProp).declareProperty((BaseProperty)this.versionProp).declareProperty((BaseProperty)this.resourceKeyProp).declareProperty((BaseProperty)this.checksumProp).declareProperty((BaseProperty)this.resourceNameProp).declareProperty((BaseProperty)this.isDuplicateProp).declareProperty((BaseProperty)this.tenantIdProp).declareProperty((BaseProperty)this.deploymentKeyProp).declareProperty((BaseProperty)this.versionTagProp);
    }

    public String getResourceId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.resourceIdProp.getValue());
    }

    public int getVersion() {
        return this.versionProp.getValue();
    }

    public ResourceMetadataRecord setVersion(int resourceVersion) {
        this.versionProp.setValue(resourceVersion);
        return this;
    }

    public String getVersionTag() {
        return BufferUtil.bufferAsString((DirectBuffer)this.versionTagProp.getValue());
    }

    public ResourceMetadataRecord setVersionTag(String versionTag) {
        this.versionTagProp.setValue(versionTag);
        return this;
    }

    public long getResourceKey() {
        return this.resourceKeyProp.getValue();
    }

    public byte[] getChecksum() {
        return BufferUtil.bufferAsArray((DirectBuffer)this.checksumProp.getValue());
    }

    public ResourceMetadataRecord setChecksum(DirectBuffer checksum) {
        this.checksumProp.setValue(checksum);
        return this;
    }

    public String getResourceName() {
        return BufferUtil.bufferAsString((DirectBuffer)this.resourceNameProp.getValue());
    }

    public ResourceMetadataRecord setResourceName(String resourceName) {
        this.resourceNameProp.setValue(resourceName);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getResourceNameBuffer() {
        return this.resourceNameProp.getValue();
    }

    public boolean isDuplicate() {
        return this.isDuplicateProp.getValue();
    }

    public ResourceMetadataRecord setDuplicate(boolean isDuplicate) {
        this.isDuplicateProp.setValue(isDuplicate);
        return this;
    }

    public long getDeploymentKey() {
        return this.deploymentKeyProp.getValue();
    }

    public ResourceMetadataRecord setDeploymentKey(long deploymentKey) {
        this.deploymentKeyProp.setValue(deploymentKey);
        return this;
    }

    public ResourceMetadataRecord setResourceId(String resourceId) {
        this.resourceIdProp.setValue(resourceId);
        return this;
    }

    public ResourceMetadataRecord setResourceKey(long resourceKey) {
        this.resourceKeyProp.setValue(resourceKey);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getResourceIdBuffer() {
        return this.resourceIdProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getChecksumBuffer() {
        return this.checksumProp.getValue();
    }

    public String getTenantId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.tenantIdProp.getValue());
    }

    public ResourceMetadataRecord setTenantId(String tenantId) {
        this.tenantIdProp.setValue(tenantId);
        return this;
    }
}

