/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.msgpack.spec;

import io.camunda.zeebe.msgpack.spec.MsgPackCodes;
import io.camunda.zeebe.msgpack.spec.MsgPackHelper;
import io.camunda.zeebe.msgpack.spec.MsgpackException;
import io.camunda.zeebe.msgpack.spec.MsgpackWriterException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class MsgPackWriter {
    private MutableDirectBuffer buffer;
    private int offset;

    public MsgPackWriter wrap(MutableDirectBuffer buffer, int offset) {
        this.buffer = buffer;
        this.offset = offset;
        return this;
    }

    public MsgPackWriter writeArrayHeader(int size) {
        this.ensurePositive(size);
        if (size < 16) {
            this.buffer.putByte(this.offset, (byte)(0xFFFFFF90 | size));
            ++this.offset;
        } else if (size < 65536) {
            this.buffer.putByte(this.offset, (byte)-36);
            ++this.offset;
            this.buffer.putShort(this.offset, (short)size, MsgPackCodes.BYTE_ORDER);
            this.offset += 2;
        } else {
            this.buffer.putByte(this.offset, (byte)-35);
            ++this.offset;
            this.buffer.putInt(this.offset, size, MsgPackCodes.BYTE_ORDER);
            this.offset += 4;
        }
        return this;
    }

    public MsgPackWriter writeMapHeader(int size) {
        this.ensurePositive(size);
        if (size < 16) {
            this.buffer.putByte(this.offset, (byte)(0xFFFFFF80 | size));
            ++this.offset;
        } else if (size < 65536) {
            this.buffer.putByte(this.offset, (byte)-34);
            ++this.offset;
            this.buffer.putShort(this.offset, (short)size, MsgPackCodes.BYTE_ORDER);
            this.offset += 2;
        } else {
            this.offset = this.writeMap32Header(this.offset, size);
        }
        return this;
    }

    private int writeMap32Header(int offset, int size) {
        this.buffer.putByte(offset, (byte)-33);
        this.buffer.putInt(++offset, size, MsgPackCodes.BYTE_ORDER);
        return offset += 4;
    }

    public void reserveMapHeader() {
        this.offset = this.writeMap32Header(this.offset, 0);
    }

    public void writeReservedMapHeader(int offset, int size) {
        this.writeMap32Header(offset, size);
    }

    public MsgPackWriter writeRaw(DirectBuffer buffer) {
        return this.writeRaw(buffer, 0, buffer.capacity());
    }

    public MsgPackWriter writeRaw(DirectBuffer buff, int offset, int length) {
        this.buffer.putBytes(this.offset, buff, offset, length);
        this.offset += length;
        return this;
    }

    public MsgPackWriter writeString(DirectBuffer bytes) {
        return this.writeString(bytes, 0, bytes.capacity());
    }

    public MsgPackWriter writeString(DirectBuffer buff, int offset, int length) {
        this.writeStringHeader(length);
        this.writeRaw(buff, offset, length);
        return this;
    }

    public MsgPackWriter writeInteger(long v) {
        if (v < -32L) {
            if (v < -32768L) {
                if (v < Integer.MIN_VALUE) {
                    this.buffer.putByte(this.offset, (byte)-45);
                    ++this.offset;
                    this.buffer.putLong(this.offset, v, MsgPackCodes.BYTE_ORDER);
                    this.offset += 8;
                } else {
                    this.buffer.putByte(this.offset, (byte)-46);
                    ++this.offset;
                    this.buffer.putInt(this.offset, (int)v, MsgPackCodes.BYTE_ORDER);
                    this.offset += 4;
                }
            } else if (v < -128L) {
                this.buffer.putByte(this.offset, (byte)-47);
                ++this.offset;
                this.buffer.putShort(this.offset, (short)v, MsgPackCodes.BYTE_ORDER);
                this.offset += 2;
            } else {
                this.buffer.putByte(this.offset, (byte)-48);
                ++this.offset;
                this.buffer.putByte(this.offset, (byte)v);
                ++this.offset;
            }
        } else if (v < 128L) {
            this.buffer.putByte(this.offset, (byte)v);
            ++this.offset;
        } else if (v < 65536L) {
            if (v < 256L) {
                this.buffer.putByte(this.offset, (byte)-52);
                ++this.offset;
                this.buffer.putByte(this.offset, (byte)v);
                ++this.offset;
            } else {
                this.buffer.putByte(this.offset, (byte)-51);
                ++this.offset;
                this.buffer.putShort(this.offset, (short)v, MsgPackCodes.BYTE_ORDER);
                this.offset += 2;
            }
        } else if (v < 0x100000000L) {
            this.buffer.putByte(this.offset, (byte)-50);
            ++this.offset;
            this.buffer.putInt(this.offset, (int)v, MsgPackCodes.BYTE_ORDER);
            this.offset += 4;
        } else {
            this.buffer.putByte(this.offset, (byte)-49);
            ++this.offset;
            this.buffer.putLong(this.offset, v, MsgPackCodes.BYTE_ORDER);
            this.offset += 8;
        }
        return this;
    }

    public MsgPackWriter writeStringHeader(int len) {
        this.ensurePositive(len);
        if (len < 32) {
            this.buffer.putByte(this.offset, (byte)(0xFFFFFFA0 | len));
            ++this.offset;
        } else if (len < 256) {
            this.buffer.putByte(this.offset, (byte)-39);
            ++this.offset;
            this.buffer.putByte(this.offset, (byte)len);
            ++this.offset;
        } else if (len < 65536) {
            this.buffer.putByte(this.offset, (byte)-38);
            ++this.offset;
            this.buffer.putShort(this.offset, (short)len, MsgPackCodes.BYTE_ORDER);
            this.offset += 2;
        } else {
            this.buffer.putByte(this.offset, (byte)-37);
            ++this.offset;
            this.buffer.putInt(this.offset, len, MsgPackCodes.BYTE_ORDER);
            this.offset += 4;
        }
        return this;
    }

    public MsgPackWriter writeBinary(DirectBuffer data) {
        return this.writeBinary(data, 0, data.capacity());
    }

    public MsgPackWriter writeBinary(DirectBuffer data, int offset, int length) {
        this.writeBinaryHeader(length);
        this.writeRaw(data, offset, length);
        return this;
    }

    public MsgPackWriter writeBinaryHeader(int len) {
        this.ensurePositive(len);
        if (len < 256) {
            this.buffer.putByte(this.offset, (byte)-60);
            ++this.offset;
            this.buffer.putByte(this.offset, (byte)len);
            ++this.offset;
        } else if (len < 65536) {
            this.buffer.putByte(this.offset, (byte)-59);
            ++this.offset;
            this.buffer.putShort(this.offset, (short)len, MsgPackCodes.BYTE_ORDER);
            this.offset += 2;
        } else {
            this.buffer.putByte(this.offset, (byte)-58);
            ++this.offset;
            this.buffer.putInt(this.offset, len, MsgPackCodes.BYTE_ORDER);
            this.offset += 4;
        }
        return this;
    }

    public MsgPackWriter writeBoolean(boolean val) {
        this.buffer.putByte(this.offset, val ? (byte)-61 : -62);
        ++this.offset;
        return this;
    }

    public MsgPackWriter writeNil() {
        this.buffer.putByte(this.offset, (byte)-64);
        ++this.offset;
        return this;
    }

    public MsgPackWriter writeFloat(double value) {
        float floatValue = (float)value;
        if ((double)floatValue == value) {
            this.buffer.putByte(this.offset, (byte)-54);
            ++this.offset;
            this.buffer.putFloat(this.offset, floatValue, MsgPackCodes.BYTE_ORDER);
            this.offset += 4;
        } else {
            this.buffer.putByte(this.offset, (byte)-53);
            ++this.offset;
            this.buffer.putDouble(this.offset, value, MsgPackCodes.BYTE_ORDER);
            this.offset += 8;
        }
        return this;
    }

    public int getOffset() {
        return this.offset;
    }

    public static int getEncodedMapHeaderLenght(int size) {
        int length = size < 16 ? 1 : (size < 65536 ? 3 : 5);
        return length;
    }

    public static int getEncodedArrayHeaderLenght(int size) {
        int length = size < 16 ? 1 : (size < 65536 ? 3 : 5);
        return length;
    }

    public static int getEncodedStringHeaderLength(int len) {
        int encodedLength = len < 32 ? 1 : (len < 256 ? 2 : (len < 65536 ? 3 : 5));
        return encodedLength;
    }

    public static int getEncodedStringLength(int len) {
        return MsgPackWriter.getEncodedStringHeaderLength(len) + len;
    }

    public static int getEncodedLongValueLength(long v) {
        int length = 1;
        if (v < -32L) {
            length = v < -32768L ? (v < Integer.MIN_VALUE ? (length += 8) : (length += 4)) : (v < -128L ? (length += 2) : ++length);
        } else if (v >= 128L) {
            length = v < 65536L ? (v < 256L ? ++length : (length += 2)) : (v < 0x100000000L ? (length += 4) : (length += 8));
        }
        return length;
    }

    public static int getEncodedBooleanValueLength() {
        return 1;
    }

    public static int getEncodedBinaryValueLength(int len) {
        int headerLength = len < 256 ? 2 : (len < 65536 ? 3 : 5);
        return headerLength + len;
    }

    private void ensurePositive(long size) {
        try {
            MsgPackHelper.ensurePositive(size);
        }
        catch (MsgpackException e) {
            throw new MsgpackWriterException(e);
        }
    }
}

