/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.camunda.zeebe.client.protocol.rest.JobResult;
import io.camunda.zeebe.client.protocol.rest.JobResultCorrections;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"denied", "deniedReason", "corrections"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"type"}, allowSetters=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", visible=true)
public class JobResultUserTask
extends JobResult {
    public static final String JSON_PROPERTY_DENIED = "denied";
    @Nullable
    private Boolean denied;
    public static final String JSON_PROPERTY_DENIED_REASON = "deniedReason";
    @Nullable
    private String deniedReason;
    public static final String JSON_PROPERTY_CORRECTIONS = "corrections";
    @Nullable
    private JobResultCorrections corrections;

    public JobResultUserTask denied(@Nullable Boolean denied) {
        this.denied = denied;
        return this;
    }

    @Nullable
    @JsonProperty(value="denied")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getDenied() {
        return this.denied;
    }

    @JsonProperty(value="denied")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDenied(@Nullable Boolean denied) {
        this.denied = denied;
    }

    public JobResultUserTask deniedReason(@Nullable String deniedReason) {
        this.deniedReason = deniedReason;
        return this;
    }

    @Nullable
    @JsonProperty(value="deniedReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDeniedReason() {
        return this.deniedReason;
    }

    @JsonProperty(value="deniedReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeniedReason(@Nullable String deniedReason) {
        this.deniedReason = deniedReason;
    }

    public JobResultUserTask corrections(@Nullable JobResultCorrections corrections) {
        this.corrections = corrections;
        return this;
    }

    @Nullable
    @JsonProperty(value="corrections")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JobResultCorrections getCorrections() {
        return this.corrections;
    }

    @JsonProperty(value="corrections")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCorrections(@Nullable JobResultCorrections corrections) {
        this.corrections = corrections;
    }

    @Override
    public JobResultUserTask type(@Nonnull JobResult.TypeEnum type) {
        this.setType(type);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobResultUserTask jobResultUserTask = (JobResultUserTask)o;
        return Objects.equals(this.denied, jobResultUserTask.denied) && Objects.equals(this.deniedReason, jobResultUserTask.deniedReason) && Objects.equals(this.corrections, jobResultUserTask.corrections) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.denied, this.deniedReason, this.corrections, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JobResultUserTask {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    denied: ").append(this.toIndentedString(this.denied)).append("\n");
        sb.append("    deniedReason: ").append(this.toIndentedString(this.deniedReason)).append("\n");
        sb.append("    corrections: ").append(this.toIndentedString(this.corrections)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @Override
    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    @Override
    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getType() != null) {
            try {
                joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getType()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getDenied() != null) {
            try {
                joiner.add(String.format("%sdenied%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDenied()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getDeniedReason() != null) {
            try {
                joiner.add(String.format("%sdeniedReason%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDeniedReason()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getCorrections() != null) {
            joiner.add(this.getCorrections().toUrlQueryString(prefix + JSON_PROPERTY_CORRECTIONS + suffix));
        }
        return joiner.toString();
    }
}

