/*
 * Camunda 8 REST API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.zeebe.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.camunda.zeebe.client.protocol.rest.DecisionInstanceStateEnum;
import io.camunda.zeebe.client.protocol.rest.DecisionInstanceTypeEnum;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Base properties for DecisionInstanceFilterRequest
 */
@JsonPropertyOrder({
  DecisionInstanceFilterRequestBase.JSON_PROPERTY_STATE,
  DecisionInstanceFilterRequestBase.JSON_PROPERTY_EVALUATION_FAILURE,
  DecisionInstanceFilterRequestBase.JSON_PROPERTY_DECISION_DEFINITION_ID,
  DecisionInstanceFilterRequestBase.JSON_PROPERTY_DECISION_DEFINITION_NAME,
  DecisionInstanceFilterRequestBase.JSON_PROPERTY_DECISION_DEFINITION_VERSION,
  DecisionInstanceFilterRequestBase.JSON_PROPERTY_DECISION_DEFINITION_TYPE,
  DecisionInstanceFilterRequestBase.JSON_PROPERTY_TENANT_ID
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-04-01T08:58:27.371823074Z[GMT]", comments = "Generator version: 7.8.0")
public class DecisionInstanceFilterRequestBase {
  public static final String JSON_PROPERTY_STATE = "state";
  private DecisionInstanceStateEnum state;

  public static final String JSON_PROPERTY_EVALUATION_FAILURE = "evaluationFailure";
  private String evaluationFailure;

  public static final String JSON_PROPERTY_DECISION_DEFINITION_ID = "decisionDefinitionId";
  private String decisionDefinitionId;

  public static final String JSON_PROPERTY_DECISION_DEFINITION_NAME = "decisionDefinitionName";
  private String decisionDefinitionName;

  public static final String JSON_PROPERTY_DECISION_DEFINITION_VERSION = "decisionDefinitionVersion";
  private Integer decisionDefinitionVersion;

  public static final String JSON_PROPERTY_DECISION_DEFINITION_TYPE = "decisionDefinitionType";
  private DecisionInstanceTypeEnum decisionDefinitionType;

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  private String tenantId;

  public DecisionInstanceFilterRequestBase() {
  }

  public DecisionInstanceFilterRequestBase state(DecisionInstanceStateEnum state) {
    
    this.state = state;
    return this;
  }

  /**
   * Get state
   * @return state
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DecisionInstanceStateEnum getState() {
    return state;
  }


  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setState(DecisionInstanceStateEnum state) {
    this.state = state;
  }

  public DecisionInstanceFilterRequestBase evaluationFailure(String evaluationFailure) {
    
    this.evaluationFailure = evaluationFailure;
    return this;
  }

  /**
   * The evaluation failure of the decision instance.
   * @return evaluationFailure
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EVALUATION_FAILURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getEvaluationFailure() {
    return evaluationFailure;
  }


  @JsonProperty(JSON_PROPERTY_EVALUATION_FAILURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEvaluationFailure(String evaluationFailure) {
    this.evaluationFailure = evaluationFailure;
  }

  public DecisionInstanceFilterRequestBase decisionDefinitionId(String decisionDefinitionId) {
    
    this.decisionDefinitionId = decisionDefinitionId;
    return this;
  }

  /**
   * The ID of the DMN decision.
   * @return decisionDefinitionId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDecisionDefinitionId() {
    return decisionDefinitionId;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionDefinitionId(String decisionDefinitionId) {
    this.decisionDefinitionId = decisionDefinitionId;
  }

  public DecisionInstanceFilterRequestBase decisionDefinitionName(String decisionDefinitionName) {
    
    this.decisionDefinitionName = decisionDefinitionName;
    return this;
  }

  /**
   * The name of the DMN decision.
   * @return decisionDefinitionName
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDecisionDefinitionName() {
    return decisionDefinitionName;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionDefinitionName(String decisionDefinitionName) {
    this.decisionDefinitionName = decisionDefinitionName;
  }

  public DecisionInstanceFilterRequestBase decisionDefinitionVersion(Integer decisionDefinitionVersion) {
    
    this.decisionDefinitionVersion = decisionDefinitionVersion;
    return this;
  }

  /**
   * The version of the decision.
   * @return decisionDefinitionVersion
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getDecisionDefinitionVersion() {
    return decisionDefinitionVersion;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionDefinitionVersion(Integer decisionDefinitionVersion) {
    this.decisionDefinitionVersion = decisionDefinitionVersion;
  }

  public DecisionInstanceFilterRequestBase decisionDefinitionType(DecisionInstanceTypeEnum decisionDefinitionType) {
    
    this.decisionDefinitionType = decisionDefinitionType;
    return this;
  }

  /**
   * Get decisionDefinitionType
   * @return decisionDefinitionType
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DecisionInstanceTypeEnum getDecisionDefinitionType() {
    return decisionDefinitionType;
  }


  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDecisionDefinitionType(DecisionInstanceTypeEnum decisionDefinitionType) {
    this.decisionDefinitionType = decisionDefinitionType;
  }

  public DecisionInstanceFilterRequestBase tenantId(String tenantId) {
    
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant ID of the decision instance.
   * @return tenantId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTenantId() {
    return tenantId;
  }


  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DecisionInstanceFilterRequestBase decisionInstanceFilterRequestBase = (DecisionInstanceFilterRequestBase) o;
    return Objects.equals(this.state, decisionInstanceFilterRequestBase.state) &&
        Objects.equals(this.evaluationFailure, decisionInstanceFilterRequestBase.evaluationFailure) &&
        Objects.equals(this.decisionDefinitionId, decisionInstanceFilterRequestBase.decisionDefinitionId) &&
        Objects.equals(this.decisionDefinitionName, decisionInstanceFilterRequestBase.decisionDefinitionName) &&
        Objects.equals(this.decisionDefinitionVersion, decisionInstanceFilterRequestBase.decisionDefinitionVersion) &&
        Objects.equals(this.decisionDefinitionType, decisionInstanceFilterRequestBase.decisionDefinitionType) &&
        Objects.equals(this.tenantId, decisionInstanceFilterRequestBase.tenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(state, evaluationFailure, decisionDefinitionId, decisionDefinitionName, decisionDefinitionVersion, decisionDefinitionType, tenantId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DecisionInstanceFilterRequestBase {\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    evaluationFailure: ").append(toIndentedString(evaluationFailure)).append("\n");
    sb.append("    decisionDefinitionId: ").append(toIndentedString(decisionDefinitionId)).append("\n");
    sb.append("    decisionDefinitionName: ").append(toIndentedString(decisionDefinitionName)).append("\n");
    sb.append("    decisionDefinitionVersion: ").append(toIndentedString(decisionDefinitionVersion)).append("\n");
    sb.append("    decisionDefinitionType: ").append(toIndentedString(decisionDefinitionType)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `state` to the URL query string
    if (getState() != null) {
      try {
        joiner.add(String.format("%sstate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getState()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `evaluationFailure` to the URL query string
    if (getEvaluationFailure() != null) {
      try {
        joiner.add(String.format("%sevaluationFailure%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getEvaluationFailure()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `decisionDefinitionId` to the URL query string
    if (getDecisionDefinitionId() != null) {
      try {
        joiner.add(String.format("%sdecisionDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDecisionDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `decisionDefinitionName` to the URL query string
    if (getDecisionDefinitionName() != null) {
      try {
        joiner.add(String.format("%sdecisionDefinitionName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDecisionDefinitionName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `decisionDefinitionVersion` to the URL query string
    if (getDecisionDefinitionVersion() != null) {
      try {
        joiner.add(String.format("%sdecisionDefinitionVersion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDecisionDefinitionVersion()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `decisionDefinitionType` to the URL query string
    if (getDecisionDefinitionType() != null) {
      try {
        joiner.add(String.format("%sdecisionDefinitionType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDecisionDefinitionType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      try {
        joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

