/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.camunda.zeebe.client.protocol.rest.OperationItem;
import io.camunda.zeebe.client.protocol.rest.ProcessInstanceReferenceItem;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"processDefinitionName", "processDefinitionVersion", "bpmnProcessId", "startDate", "endDate", "state", "incident", "hasActiveOperation", "tenantId", "rootInstanceId", "operations", "callHierarchy"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ProcessInstanceItemBase {
    public static final String JSON_PROPERTY_PROCESS_DEFINITION_NAME = "processDefinitionName";
    private String processDefinitionName;
    public static final String JSON_PROPERTY_PROCESS_DEFINITION_VERSION = "processDefinitionVersion";
    private Integer processDefinitionVersion;
    public static final String JSON_PROPERTY_BPMN_PROCESS_ID = "bpmnProcessId";
    private String bpmnProcessId;
    public static final String JSON_PROPERTY_START_DATE = "startDate";
    private String startDate;
    public static final String JSON_PROPERTY_END_DATE = "endDate";
    private String endDate;
    public static final String JSON_PROPERTY_STATE = "state";
    private StateEnum state;
    public static final String JSON_PROPERTY_INCIDENT = "incident";
    private Boolean incident;
    public static final String JSON_PROPERTY_HAS_ACTIVE_OPERATION = "hasActiveOperation";
    private Boolean hasActiveOperation;
    public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
    private String tenantId;
    public static final String JSON_PROPERTY_ROOT_INSTANCE_ID = "rootInstanceId";
    private String rootInstanceId;
    public static final String JSON_PROPERTY_OPERATIONS = "operations";
    private List<OperationItem> operations = new ArrayList<OperationItem>();
    public static final String JSON_PROPERTY_CALL_HIERARCHY = "callHierarchy";
    private List<ProcessInstanceReferenceItem> callHierarchy = new ArrayList<ProcessInstanceReferenceItem>();

    public ProcessInstanceItemBase processDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
        return this;
    }

    @Nullable
    @JsonProperty(value="processDefinitionName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    @JsonProperty(value="processDefinitionName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProcessDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
    }

    public ProcessInstanceItemBase processDefinitionVersion(Integer processDefinitionVersion) {
        this.processDefinitionVersion = processDefinitionVersion;
        return this;
    }

    @Nullable
    @JsonProperty(value="processDefinitionVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getProcessDefinitionVersion() {
        return this.processDefinitionVersion;
    }

    @JsonProperty(value="processDefinitionVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProcessDefinitionVersion(Integer processDefinitionVersion) {
        this.processDefinitionVersion = processDefinitionVersion;
    }

    public ProcessInstanceItemBase bpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessId = bpmnProcessId;
        return this;
    }

    @Nullable
    @JsonProperty(value="bpmnProcessId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    @JsonProperty(value="bpmnProcessId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessId = bpmnProcessId;
    }

    public ProcessInstanceItemBase startDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public ProcessInstanceItemBase endDate(String endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public ProcessInstanceItemBase state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StateEnum getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(StateEnum state) {
        this.state = state;
    }

    public ProcessInstanceItemBase incident(Boolean incident) {
        this.incident = incident;
        return this;
    }

    @Nullable
    @JsonProperty(value="incident")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncident() {
        return this.incident;
    }

    @JsonProperty(value="incident")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncident(Boolean incident) {
        this.incident = incident;
    }

    public ProcessInstanceItemBase hasActiveOperation(Boolean hasActiveOperation) {
        this.hasActiveOperation = hasActiveOperation;
        return this;
    }

    @Nullable
    @JsonProperty(value="hasActiveOperation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasActiveOperation() {
        return this.hasActiveOperation;
    }

    @JsonProperty(value="hasActiveOperation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasActiveOperation(Boolean hasActiveOperation) {
        this.hasActiveOperation = hasActiveOperation;
    }

    public ProcessInstanceItemBase tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Nullable
    @JsonProperty(value="tenantId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTenantId() {
        return this.tenantId;
    }

    @JsonProperty(value="tenantId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public ProcessInstanceItemBase rootInstanceId(String rootInstanceId) {
        this.rootInstanceId = rootInstanceId;
        return this;
    }

    @Nullable
    @JsonProperty(value="rootInstanceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRootInstanceId() {
        return this.rootInstanceId;
    }

    @JsonProperty(value="rootInstanceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRootInstanceId(String rootInstanceId) {
        this.rootInstanceId = rootInstanceId;
    }

    public ProcessInstanceItemBase operations(List<OperationItem> operations) {
        this.operations = operations;
        return this;
    }

    public ProcessInstanceItemBase addOperationsItem(OperationItem operationsItem) {
        if (this.operations == null) {
            this.operations = new ArrayList<OperationItem>();
        }
        this.operations.add(operationsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="operations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<OperationItem> getOperations() {
        return this.operations;
    }

    @JsonProperty(value="operations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOperations(List<OperationItem> operations) {
        this.operations = operations;
    }

    public ProcessInstanceItemBase callHierarchy(List<ProcessInstanceReferenceItem> callHierarchy) {
        this.callHierarchy = callHierarchy;
        return this;
    }

    public ProcessInstanceItemBase addCallHierarchyItem(ProcessInstanceReferenceItem callHierarchyItem) {
        if (this.callHierarchy == null) {
            this.callHierarchy = new ArrayList<ProcessInstanceReferenceItem>();
        }
        this.callHierarchy.add(callHierarchyItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="callHierarchy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ProcessInstanceReferenceItem> getCallHierarchy() {
        return this.callHierarchy;
    }

    @JsonProperty(value="callHierarchy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCallHierarchy(List<ProcessInstanceReferenceItem> callHierarchy) {
        this.callHierarchy = callHierarchy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessInstanceItemBase processInstanceItemBase = (ProcessInstanceItemBase)o;
        return Objects.equals(this.processDefinitionName, processInstanceItemBase.processDefinitionName) && Objects.equals(this.processDefinitionVersion, processInstanceItemBase.processDefinitionVersion) && Objects.equals(this.bpmnProcessId, processInstanceItemBase.bpmnProcessId) && Objects.equals(this.startDate, processInstanceItemBase.startDate) && Objects.equals(this.endDate, processInstanceItemBase.endDate) && Objects.equals((Object)this.state, (Object)processInstanceItemBase.state) && Objects.equals(this.incident, processInstanceItemBase.incident) && Objects.equals(this.hasActiveOperation, processInstanceItemBase.hasActiveOperation) && Objects.equals(this.tenantId, processInstanceItemBase.tenantId) && Objects.equals(this.rootInstanceId, processInstanceItemBase.rootInstanceId) && Objects.equals(this.operations, processInstanceItemBase.operations) && Objects.equals(this.callHierarchy, processInstanceItemBase.callHierarchy);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.processDefinitionName, this.processDefinitionVersion, this.bpmnProcessId, this.startDate, this.endDate, this.state, this.incident, this.hasActiveOperation, this.tenantId, this.rootInstanceId, this.operations, this.callHierarchy});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessInstanceItemBase {\n");
        sb.append("    processDefinitionName: ").append(this.toIndentedString(this.processDefinitionName)).append("\n");
        sb.append("    processDefinitionVersion: ").append(this.toIndentedString(this.processDefinitionVersion)).append("\n");
        sb.append("    bpmnProcessId: ").append(this.toIndentedString(this.bpmnProcessId)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    incident: ").append(this.toIndentedString(this.incident)).append("\n");
        sb.append("    hasActiveOperation: ").append(this.toIndentedString(this.hasActiveOperation)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("    rootInstanceId: ").append(this.toIndentedString(this.rootInstanceId)).append("\n");
        sb.append("    operations: ").append(this.toIndentedString(this.operations)).append("\n");
        sb.append("    callHierarchy: ").append(this.toIndentedString(this.callHierarchy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getProcessDefinitionName() != null) {
            try {
                joiner.add(String.format("%sprocessDefinitionName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getProcessDefinitionName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getProcessDefinitionVersion() != null) {
            try {
                joiner.add(String.format("%sprocessDefinitionVersion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getProcessDefinitionVersion()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getBpmnProcessId() != null) {
            try {
                joiner.add(String.format("%sbpmnProcessId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getBpmnProcessId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getStartDate() != null) {
            try {
                joiner.add(String.format("%sstartDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getStartDate()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getEndDate() != null) {
            try {
                joiner.add(String.format("%sendDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getEndDate()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getState() != null) {
            try {
                joiner.add(String.format("%sstate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getState()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getIncident() != null) {
            try {
                joiner.add(String.format("%sincident%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getIncident()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getHasActiveOperation() != null) {
            try {
                joiner.add(String.format("%shasActiveOperation%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getHasActiveOperation()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getTenantId() != null) {
            try {
                joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getRootInstanceId() != null) {
            try {
                joiner.add(String.format("%srootInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getRootInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getOperations() != null) {
            for (i = 0; i < this.getOperations().size(); ++i) {
                if (this.getOperations().get(i) == null) continue;
                joiner.add(this.getOperations().get(i).toUrlQueryString(String.format("%soperations%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getCallHierarchy() != null) {
            for (i = 0; i < this.getCallHierarchy().size(); ++i) {
                if (this.getCallHierarchy().get(i) == null) continue;
                joiner.add(this.getCallHierarchy().get(i).toUrlQueryString(String.format("%scallHierarchy%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }

    public static enum StateEnum {
        ACTIVE("ACTIVE"),
        INCIDENT("INCIDENT"),
        COMPLETED("COMPLETED"),
        CANCELED("CANCELED"),
        UNKNOWN("UNKNOWN"),
        UNSPECIFIED("UNSPECIFIED"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

