/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.zeebe.client.CredentialsProvider;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.ZeebeClientConfiguration;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.command.ActivateJobsCommandStep1;
import io.camunda.zeebe.client.api.command.AddPermissionsCommandStep1;
import io.camunda.zeebe.client.api.command.AssignUserTaskCommandStep1;
import io.camunda.zeebe.client.api.command.BroadcastSignalCommandStep1;
import io.camunda.zeebe.client.api.command.CancelProcessInstanceCommandStep1;
import io.camunda.zeebe.client.api.command.ClientException;
import io.camunda.zeebe.client.api.command.ClockPinCommandStep1;
import io.camunda.zeebe.client.api.command.ClockResetCommandStep1;
import io.camunda.zeebe.client.api.command.CompleteJobCommandStep1;
import io.camunda.zeebe.client.api.command.CompleteUserTaskCommandStep1;
import io.camunda.zeebe.client.api.command.CorrelateMessageCommandStep1;
import io.camunda.zeebe.client.api.command.CreateProcessInstanceCommandStep1;
import io.camunda.zeebe.client.api.command.CreateUserCommandStep1;
import io.camunda.zeebe.client.api.command.DeleteResourceCommandStep1;
import io.camunda.zeebe.client.api.command.DeployProcessCommandStep1;
import io.camunda.zeebe.client.api.command.DeployResourceCommandStep1;
import io.camunda.zeebe.client.api.command.EvaluateDecisionCommandStep1;
import io.camunda.zeebe.client.api.command.FailJobCommandStep1;
import io.camunda.zeebe.client.api.command.MigrateProcessInstanceCommandStep1;
import io.camunda.zeebe.client.api.command.ModifyProcessInstanceCommandStep1;
import io.camunda.zeebe.client.api.command.PublishMessageCommandStep1;
import io.camunda.zeebe.client.api.command.ResolveIncidentCommandStep1;
import io.camunda.zeebe.client.api.command.SetVariablesCommandStep1;
import io.camunda.zeebe.client.api.command.StreamJobsCommandStep1;
import io.camunda.zeebe.client.api.command.ThrowErrorCommandStep1;
import io.camunda.zeebe.client.api.command.TopologyRequestStep1;
import io.camunda.zeebe.client.api.command.UnassignUserTaskCommandStep1;
import io.camunda.zeebe.client.api.command.UpdateJobCommandStep1;
import io.camunda.zeebe.client.api.command.UpdateRetriesJobCommandStep1;
import io.camunda.zeebe.client.api.command.UpdateTimeoutJobCommandStep1;
import io.camunda.zeebe.client.api.command.UpdateUserTaskCommandStep1;
import io.camunda.zeebe.client.api.fetch.DecisionDefinitionGetXmlRequest;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.search.query.DecisionDefinitionQuery;
import io.camunda.zeebe.client.api.search.query.DecisionRequirementsQuery;
import io.camunda.zeebe.client.api.search.query.FlownodeInstanceQuery;
import io.camunda.zeebe.client.api.search.query.IncidentQuery;
import io.camunda.zeebe.client.api.search.query.ProcessInstanceQuery;
import io.camunda.zeebe.client.api.search.query.UserTaskQuery;
import io.camunda.zeebe.client.api.worker.JobClient;
import io.camunda.zeebe.client.api.worker.JobWorkerBuilderStep1;
import io.camunda.zeebe.client.impl.Loggers;
import io.camunda.zeebe.client.impl.NoopCredentialsProvider;
import io.camunda.zeebe.client.impl.ZeebeCallCredentials;
import io.camunda.zeebe.client.impl.command.AddPermissionsCommandImpl;
import io.camunda.zeebe.client.impl.command.AssignUserTaskCommandImpl;
import io.camunda.zeebe.client.impl.command.BroadcastSignalCommandImpl;
import io.camunda.zeebe.client.impl.command.CancelProcessInstanceCommandImpl;
import io.camunda.zeebe.client.impl.command.ClockPinCommandImpl;
import io.camunda.zeebe.client.impl.command.ClockResetCommandImpl;
import io.camunda.zeebe.client.impl.command.CompleteUserTaskCommandImpl;
import io.camunda.zeebe.client.impl.command.CorrelateMessageCommandImpl;
import io.camunda.zeebe.client.impl.command.CreateProcessInstanceCommandImpl;
import io.camunda.zeebe.client.impl.command.CreateUserCommandImpl;
import io.camunda.zeebe.client.impl.command.DeleteResourceCommandImpl;
import io.camunda.zeebe.client.impl.command.DeployProcessCommandImpl;
import io.camunda.zeebe.client.impl.command.DeployResourceCommandImpl;
import io.camunda.zeebe.client.impl.command.EvaluateDecisionCommandImpl;
import io.camunda.zeebe.client.impl.command.JobUpdateCommandImpl;
import io.camunda.zeebe.client.impl.command.JobUpdateRetriesCommandImpl;
import io.camunda.zeebe.client.impl.command.JobUpdateTimeoutCommandImpl;
import io.camunda.zeebe.client.impl.command.MigrateProcessInstanceCommandImpl;
import io.camunda.zeebe.client.impl.command.ModifyProcessInstanceCommandImpl;
import io.camunda.zeebe.client.impl.command.PublishMessageCommandImpl;
import io.camunda.zeebe.client.impl.command.ResolveIncidentCommandImpl;
import io.camunda.zeebe.client.impl.command.SetVariablesCommandImpl;
import io.camunda.zeebe.client.impl.command.StreamJobsCommandImpl;
import io.camunda.zeebe.client.impl.command.TopologyRequestImpl;
import io.camunda.zeebe.client.impl.command.UnassignUserTaskCommandImpl;
import io.camunda.zeebe.client.impl.command.UpdateUserTaskCommandImpl;
import io.camunda.zeebe.client.impl.fetch.DecisionDefinitionGetXmlRequestImpl;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpClientFactory;
import io.camunda.zeebe.client.impl.search.query.DecisionDefinitionQueryImpl;
import io.camunda.zeebe.client.impl.search.query.DecisionRequirementsQueryImpl;
import io.camunda.zeebe.client.impl.search.query.FlowNodeInstanceQueryImpl;
import io.camunda.zeebe.client.impl.search.query.IncidentQueryImpl;
import io.camunda.zeebe.client.impl.search.query.ProcessInstanceQueryImpl;
import io.camunda.zeebe.client.impl.search.query.UserTaskQueryImpl;
import io.camunda.zeebe.client.impl.util.ExecutorResource;
import io.camunda.zeebe.client.impl.util.VersionUtil;
import io.camunda.zeebe.client.impl.worker.JobClientImpl;
import io.camunda.zeebe.client.impl.worker.JobWorkerBuilderImpl;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.grpc.CallCredentials;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.handler.ssl.SslContext;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public final class ZeebeClientImpl
implements ZeebeClient {
    private final ZeebeClientConfiguration config;
    private final JsonMapper jsonMapper;
    private final GatewayGrpc.GatewayStub asyncStub;
    private final ManagedChannel channel;
    private final ExecutorResource executorResource;
    private final List<Closeable> closeables = new CopyOnWriteArrayList<Closeable>();
    private final JobClient jobClient;
    private final CredentialsProvider credentialsProvider;
    private final HttpClient httpClient;

    public ZeebeClientImpl(ZeebeClientConfiguration configuration) {
        this(configuration, ZeebeClientImpl.buildChannel(configuration));
    }

    public ZeebeClientImpl(ZeebeClientConfiguration configuration, ManagedChannel channel) {
        this(configuration, channel, ZeebeClientImpl.buildGatewayStub(channel, configuration));
    }

    public ZeebeClientImpl(ZeebeClientConfiguration configuration, ManagedChannel channel, HttpClient httpClient) {
        this(configuration, channel, ZeebeClientImpl.buildGatewayStub(channel, configuration), ZeebeClientImpl.buildExecutorService(configuration), httpClient);
    }

    public ZeebeClientImpl(ZeebeClientConfiguration configuration, ManagedChannel channel, GatewayGrpc.GatewayStub gatewayStub) {
        this(configuration, channel, gatewayStub, ZeebeClientImpl.buildExecutorService(configuration));
    }

    public ZeebeClientImpl(ZeebeClientConfiguration config, ManagedChannel channel, GatewayGrpc.GatewayStub gatewayStub, ExecutorResource executorResource) {
        this(config, channel, gatewayStub, executorResource, ZeebeClientImpl.buildHttpClient(config));
    }

    public ZeebeClientImpl(ZeebeClientConfiguration config, ManagedChannel channel, GatewayGrpc.GatewayStub gatewayStub, ExecutorResource executorResource, HttpClient httpClient) {
        this.config = config;
        this.jsonMapper = config.getJsonMapper();
        this.channel = channel;
        this.asyncStub = gatewayStub;
        this.executorResource = executorResource;
        this.httpClient = httpClient;
        this.credentialsProvider = config.getCredentialsProvider() != null ? config.getCredentialsProvider() : new NoopCredentialsProvider();
        this.jobClient = this.newJobClient();
        this.httpClient.start();
    }

    private static HttpClient buildHttpClient(ZeebeClientConfiguration config) {
        return new HttpClientFactory(config).createClient();
    }

    public static ManagedChannel buildChannel(ZeebeClientConfiguration config) {
        Map<String, Object> serviceConfig;
        URI address = config.getGrpcAddress();
        NettyChannelBuilder channelBuilder = NettyChannelBuilder.forAddress((String)address.getHost(), (int)address.getPort());
        ZeebeClientImpl.configureConnectionSecurity(config, channelBuilder);
        channelBuilder.keepAliveTime(config.getKeepAlive().toMillis(), TimeUnit.MILLISECONDS);
        channelBuilder.userAgent("zeebe-client-java/" + VersionUtil.getVersion());
        channelBuilder.maxInboundMessageSize(config.getMaxMessageSize());
        channelBuilder.maxInboundMetadataSize(config.getMaxMetadataSize());
        if (config.useDefaultRetryPolicy() && !(serviceConfig = ZeebeClientImpl.defaultServiceConfig()).isEmpty()) {
            channelBuilder.defaultServiceConfig(serviceConfig);
            channelBuilder.enableRetry();
        }
        return channelBuilder.build();
    }

    private static CallCredentials buildCallCredentials(ZeebeClientConfiguration config) {
        CredentialsProvider customCredentialsProvider = config.getCredentialsProvider();
        if (customCredentialsProvider == null) {
            return null;
        }
        return new ZeebeCallCredentials(customCredentialsProvider);
    }

    private static void configureConnectionSecurity(ZeebeClientConfiguration config, NettyChannelBuilder channelBuilder) {
        if (!config.isPlaintextConnectionEnabled()) {
            String certificatePath = config.getCaCertificatePath();
            SslContext sslContext = null;
            if (certificatePath != null) {
                if (certificatePath.isEmpty()) {
                    throw new IllegalArgumentException("Expected valid certificate path but found empty path instead.");
                }
                try (FileInputStream certInputStream = new FileInputStream(certificatePath);){
                    sslContext = GrpcSslContexts.forClient().trustManager((InputStream)certInputStream).build();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            channelBuilder.useTransportSecurity().sslContext(sslContext);
            if (config.getOverrideAuthority() != null) {
                channelBuilder.overrideAuthority(config.getOverrideAuthority());
            }
        } else {
            channelBuilder.usePlaintext();
        }
    }

    public static GatewayGrpc.GatewayStub buildGatewayStub(ManagedChannel channel, ZeebeClientConfiguration config) {
        CallCredentials credentials = ZeebeClientImpl.buildCallCredentials(config);
        GatewayGrpc.GatewayStub gatewayStub = (GatewayGrpc.GatewayStub)GatewayGrpc.newStub((Channel)channel).withCallCredentials(credentials);
        if (!config.getInterceptors().isEmpty()) {
            return (GatewayGrpc.GatewayStub)gatewayStub.withInterceptors(config.getInterceptors().toArray(new ClientInterceptor[0]));
        }
        return gatewayStub;
    }

    private static Map<String, Object> defaultServiceConfig() {
        ObjectMapper objectMapper = new ObjectMapper();
        URL defaultServiceConfig = ClassLoader.getSystemClassLoader().getResource("gateway-service-config.json");
        if (defaultServiceConfig == null) {
            Loggers.LOGGER.info("No default service config found on classpath; will not configure a default retry policy");
            return new HashMap<String, Object>();
        }
        try {
            return (Map)objectMapper.readValue(defaultServiceConfig, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException e) {
            Loggers.LOGGER.warn("Failed to read default service config from classpath; will not configure a default retry policy", (Throwable)e);
            return new HashMap<String, Object>();
        }
    }

    private static ExecutorResource buildExecutorService(ZeebeClientConfiguration configuration) {
        if (configuration.jobWorkerExecutor() != null) {
            return new ExecutorResource(configuration.jobWorkerExecutor(), configuration.ownsJobWorkerExecutor());
        }
        int threadCount = configuration.getNumJobWorkerExecutionThreads();
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(threadCount);
        return new ExecutorResource(executor, true);
    }

    @Override
    public TopologyRequestStep1 newTopologyRequest() {
        return new TopologyRequestImpl(this.asyncStub, this.httpClient, this.config.getDefaultRequestTimeout(), this.credentialsProvider::shouldRetryRequest, this.config.preferRestOverGrpc());
    }

    @Override
    public ZeebeClientConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public void close() {
        this.closeables.forEach(c -> {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        this.executorResource.close();
        this.channel.shutdownNow();
        try {
            if (!this.channel.awaitTermination(15L, TimeUnit.SECONDS)) {
                throw new ClientException("Timed out awaiting termination of in-flight request channel after 15 seconds");
            }
        }
        catch (InterruptedException e) {
            throw new ClientException("Unexpectedly interrupted awaiting termination of in-flight request channel", e);
        }
        try {
            this.httpClient.close();
        }
        catch (Exception e) {
            throw new ClientException("Failed closing http client.", e);
        }
    }

    @Override
    public DeployProcessCommandStep1 newDeployCommand() {
        return new DeployProcessCommandImpl(this.asyncStub, this.config.getDefaultRequestTimeout(), this.credentialsProvider::shouldRetryRequest);
    }

    @Override
    public DeployResourceCommandStep1 newDeployResourceCommand() {
        return new DeployResourceCommandImpl(this.asyncStub, this.config, this.credentialsProvider::shouldRetryRequest, this.httpClient, this.config.preferRestOverGrpc(), this.jsonMapper);
    }

    @Override
    public CreateProcessInstanceCommandStep1 newCreateInstanceCommand() {
        return new CreateProcessInstanceCommandImpl(this.asyncStub, this.jsonMapper, this.config, this.credentialsProvider::shouldRetryRequest, this.httpClient, this.config.preferRestOverGrpc());
    }

    @Override
    public ModifyProcessInstanceCommandStep1 newModifyProcessInstanceCommand(long processInstanceKey) {
        return new ModifyProcessInstanceCommandImpl(processInstanceKey, this.jsonMapper, this.asyncStub, this.credentialsProvider::shouldRetryRequest, this.httpClient, this.config);
    }

    @Override
    public MigrateProcessInstanceCommandStep1 newMigrateProcessInstanceCommand(long processInstanceKey) {
        return new MigrateProcessInstanceCommandImpl(processInstanceKey, this.asyncStub, this.credentialsProvider::shouldRetryRequest, this.httpClient, this.config, this.jsonMapper);
    }

    @Override
    public CancelProcessInstanceCommandStep1 newCancelInstanceCommand(long processInstanceKey) {
        return new CancelProcessInstanceCommandImpl(this.asyncStub, processInstanceKey, this.credentialsProvider::shouldRetryRequest, this.httpClient, this.config, this.jsonMapper);
    }

    @Override
    public SetVariablesCommandStep1 newSetVariablesCommand(long elementInstanceKey) {
        return new SetVariablesCommandImpl(this.asyncStub, this.jsonMapper, elementInstanceKey, this.config.getDefaultRequestTimeout(), this.credentialsProvider::shouldRetryRequest, this.httpClient, this.config.preferRestOverGrpc());
    }

    @Override
    public EvaluateDecisionCommandStep1 newEvaluateDecisionCommand() {
        return new EvaluateDecisionCommandImpl(this.asyncStub, this.jsonMapper, this.config, this.credentialsProvider::shouldRetryRequest, this.httpClient);
    }

    @Override
    public PublishMessageCommandStep1 newPublishMessageCommand() {
        return new PublishMessageCommandImpl(this.asyncStub, this.config, this.jsonMapper, this.credentialsProvider::shouldRetryRequest, this.httpClient, this.config.preferRestOverGrpc());
    }

    @Override
    public CorrelateMessageCommandStep1 newCorrelateMessageCommand() {
        return new CorrelateMessageCommandImpl(this.httpClient, this.jsonMapper);
    }

    @Override
    public BroadcastSignalCommandStep1 newBroadcastSignalCommand() {
        return new BroadcastSignalCommandImpl(this.asyncStub, this.config, this.jsonMapper, this.credentialsProvider::shouldRetryRequest, this.httpClient);
    }

    @Override
    public ResolveIncidentCommandStep1 newResolveIncidentCommand(long incidentKey) {
        return new ResolveIncidentCommandImpl(this.asyncStub, incidentKey, this.config.getDefaultRequestTimeout(), this.credentialsProvider::shouldRetryRequest, this.httpClient, this.config.preferRestOverGrpc());
    }

    @Override
    public UpdateRetriesJobCommandStep1 newUpdateRetriesCommand(long jobKey) {
        return new JobUpdateRetriesCommandImpl(this.asyncStub, jobKey, this.config.getDefaultRequestTimeout(), this.credentialsProvider::shouldRetryRequest, this.httpClient, this.config.preferRestOverGrpc(), this.jsonMapper);
    }

    @Override
    public UpdateRetriesJobCommandStep1 newUpdateRetriesCommand(ActivatedJob job) {
        return this.newUpdateRetriesCommand(job.getKey());
    }

    @Override
    public UpdateTimeoutJobCommandStep1 newUpdateTimeoutCommand(long jobKey) {
        return new JobUpdateTimeoutCommandImpl(this.asyncStub, jobKey, this.config.getDefaultRequestTimeout(), this.credentialsProvider::shouldRetryRequest, this.httpClient, this.config.preferRestOverGrpc(), this.jsonMapper);
    }

    @Override
    public UpdateTimeoutJobCommandStep1 newUpdateTimeoutCommand(ActivatedJob job) {
        return this.newUpdateTimeoutCommand(job.getKey());
    }

    @Override
    public JobWorkerBuilderStep1 newWorker() {
        return new JobWorkerBuilderImpl(this.config, this.jobClient, this.executorResource.executor(), this.closeables);
    }

    @Override
    public DeleteResourceCommandStep1 newDeleteResourceCommand(long resourceKey) {
        return new DeleteResourceCommandImpl(resourceKey, this.asyncStub, this.credentialsProvider::shouldRetryRequest, this.httpClient, this.config, this.jsonMapper);
    }

    @Override
    public CompleteUserTaskCommandStep1 newUserTaskCompleteCommand(long userTaskKey) {
        return new CompleteUserTaskCommandImpl(this.httpClient, this.jsonMapper, userTaskKey);
    }

    @Override
    public AssignUserTaskCommandStep1 newUserTaskAssignCommand(long userTaskKey) {
        return new AssignUserTaskCommandImpl(this.httpClient, this.jsonMapper, userTaskKey);
    }

    @Override
    public UpdateUserTaskCommandStep1 newUserTaskUpdateCommand(long userTaskKey) {
        return new UpdateUserTaskCommandImpl(this.httpClient, this.jsonMapper, userTaskKey);
    }

    @Override
    public UnassignUserTaskCommandStep1 newUserTaskUnassignCommand(long userTaskKey) {
        return new UnassignUserTaskCommandImpl(this.httpClient, userTaskKey);
    }

    @Override
    public UpdateJobCommandStep1 newUpdateJobCommand(long jobKey) {
        return new JobUpdateCommandImpl(jobKey, this.httpClient, this.jsonMapper);
    }

    @Override
    public UpdateJobCommandStep1 newUpdateJobCommand(ActivatedJob job) {
        return this.newUpdateJobCommand(job.getKey());
    }

    @Override
    public ClockPinCommandStep1 newClockPinCommand() {
        return new ClockPinCommandImpl(this.httpClient, this.jsonMapper);
    }

    @Override
    public ClockResetCommandStep1 newClockResetCommand() {
        return new ClockResetCommandImpl(this.httpClient);
    }

    @Override
    public ProcessInstanceQuery newProcessInstanceQuery() {
        return new ProcessInstanceQueryImpl(this.httpClient, this.jsonMapper);
    }

    @Override
    public FlownodeInstanceQuery newFlownodeInstanceQuery() {
        return new FlowNodeInstanceQueryImpl(this.httpClient, this.jsonMapper);
    }

    @Override
    public UserTaskQuery newUserTaskQuery() {
        return new UserTaskQueryImpl(this.httpClient, this.jsonMapper);
    }

    @Override
    public DecisionRequirementsQuery newDecisionRequirementsQuery() {
        return new DecisionRequirementsQueryImpl(this.httpClient, this.jsonMapper);
    }

    @Override
    public DecisionDefinitionQuery newDecisionDefinitionQuery() {
        return new DecisionDefinitionQueryImpl(this.httpClient, this.jsonMapper);
    }

    @Override
    public DecisionDefinitionGetXmlRequest newDecisionDefinitionGetXmlRequest(long decisionKey) {
        return new DecisionDefinitionGetXmlRequestImpl(this.httpClient, decisionKey);
    }

    @Override
    public IncidentQuery newIncidentQuery() {
        return new IncidentQueryImpl(this.httpClient, this.jsonMapper);
    }

    @Override
    public CreateUserCommandStep1 newUserCreateCommand() {
        return new CreateUserCommandImpl(this.httpClient, this.jsonMapper);
    }

    @Override
    public AddPermissionsCommandStep1 newAddPermissionsCommand(long ownerKey) {
        return new AddPermissionsCommandImpl(ownerKey, this.httpClient, this.jsonMapper);
    }

    private JobClient newJobClient() {
        return new JobClientImpl(this.asyncStub, this.httpClient, this.config, this.jsonMapper, this.credentialsProvider::shouldRetryRequest);
    }

    @Override
    public CompleteJobCommandStep1 newCompleteCommand(long jobKey) {
        return this.jobClient.newCompleteCommand(jobKey);
    }

    @Override
    public CompleteJobCommandStep1 newCompleteCommand(ActivatedJob job) {
        return this.newCompleteCommand(job.getKey());
    }

    @Override
    public FailJobCommandStep1 newFailCommand(long jobKey) {
        return this.jobClient.newFailCommand(jobKey);
    }

    @Override
    public FailJobCommandStep1 newFailCommand(ActivatedJob job) {
        return this.newFailCommand(job.getKey());
    }

    @Override
    public ThrowErrorCommandStep1 newThrowErrorCommand(long jobKey) {
        return this.jobClient.newThrowErrorCommand(jobKey);
    }

    @Override
    public ThrowErrorCommandStep1 newThrowErrorCommand(ActivatedJob job) {
        return this.newThrowErrorCommand(job.getKey());
    }

    @Override
    public ActivateJobsCommandStep1 newActivateJobsCommand() {
        return this.jobClient.newActivateJobsCommand();
    }

    @Override
    public StreamJobsCommandStep1 newStreamJobsCommand() {
        return new StreamJobsCommandImpl(this.asyncStub, this.jsonMapper, this.credentialsProvider::shouldRetryRequest, this.config);
    }
}

